/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.procedure2.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ByteSlot
extends OutputStream {
    private static final int LARGE_GROW_SIZE_THRESHOLD = 0x800000;
    private static final int LARGE_GROW_SIZE = 0x100000;
    private static final int RESET_THRESHOLD = 0x4000000;
    private static final int GROW_ALIGN = 128;
    private byte[] buf;
    private int head;
    private int size;

    public void reset() {
        if (this.buf != null && this.buf.length > 0x4000000) {
            this.buf = null;
        }
        this.head = 0;
        this.size = 0;
    }

    public void markHead() {
        this.head = this.size;
    }

    public int getHead() {
        return this.head;
    }

    public int size() {
        return this.size;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void writeAt(int offset, int b) {
        this.head = Math.min(this.head, offset);
        this.buf[offset] = (byte)b;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.size + 1);
        this.buf[this.size++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.size + len);
        System.arraycopy(b, off, this.buf, this.size, len);
        this.size += len;
    }

    public void writeTo(OutputStream stream) throws IOException {
        if (this.head != 0) {
            stream.write(this.buf, this.head, this.size - this.head);
            stream.write(this.buf, 0, this.head);
        } else {
            stream.write(this.buf, 0, this.size);
        }
    }

    private void ensureCapacity(int minCapacity) {
        minCapacity = minCapacity + 127 & 0xFFFFFF80;
        if (this.buf == null) {
            this.buf = new byte[minCapacity];
        } else if (minCapacity > this.buf.length) {
            int newCapacity = this.buf.length <= 0x800000 ? this.buf.length << 1 : this.buf.length + 0x100000;
            if (minCapacity > newCapacity) {
                newCapacity = minCapacity;
            }
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
    }
}

