/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc;

import org.apache.flink.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.flink.hbase.shaded.com.google.protobuf.Message;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ByteStringer;

@InterfaceAudience.Private
public final class CoprocessorRpcUtils {
    private static String hbaseServicePackage;

    private CoprocessorRpcUtils() {
    }

    public static String getServiceName(Descriptors.ServiceDescriptor service) {
        if (service.getFullName().startsWith(hbaseServicePackage)) {
            return service.getName();
        }
        return service.getFullName();
    }

    public static ClientProtos.CoprocessorServiceCall buildServiceCall(byte[] row, Descriptors.MethodDescriptor method, Message request) {
        return ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteStringer.wrap(row)).setServiceName(CoprocessorRpcUtils.getServiceName(method.getService())).setMethodName(method.getName()).setRequest(request.toByteString()).build();
    }

    static {
        Descriptors.ServiceDescriptor clientService = ClientProtos.ClientService.getDescriptor();
        hbaseServicePackage = clientService.getFullName().substring(0, clientService.getFullName().lastIndexOf(clientService.getName()));
    }
}

