/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.row;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.hbase.shaded.com.google.common.collect.Lists;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.row.RowNodeWriter;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.vint.UFIntTool;

@InterfaceAudience.Private
public class RowSectionWriter {
    protected PrefixTreeEncoder prefixTreeEncoder;
    protected PrefixTreeBlockMeta blockMeta;
    protected int numBytes;
    protected ArrayList<TokenizerNode> nonLeaves;
    protected ArrayList<TokenizerNode> leaves;
    protected ArrayList<RowNodeWriter> leafWriters;
    protected ArrayList<RowNodeWriter> nonLeafWriters;
    protected int numLeafWriters;
    protected int numNonLeafWriters;

    public RowSectionWriter() {
        this.nonLeaves = Lists.newArrayList();
        this.leaves = Lists.newArrayList();
        this.leafWriters = Lists.newArrayList();
        this.nonLeafWriters = Lists.newArrayList();
    }

    public RowSectionWriter(PrefixTreeEncoder prefixTreeEncoder) {
        this.reconstruct(prefixTreeEncoder);
    }

    public void reconstruct(PrefixTreeEncoder prefixTreeEncoder) {
        this.prefixTreeEncoder = prefixTreeEncoder;
        this.blockMeta = prefixTreeEncoder.getBlockMeta();
        this.reset();
    }

    public void reset() {
        this.numBytes = 0;
        this.nonLeaves.clear();
        this.leaves.clear();
        this.numLeafWriters = 0;
        this.numNonLeafWriters = 0;
    }

    public RowSectionWriter compile() {
        int offsetBytes;
        int totalRowBytes;
        this.blockMeta.setMaxRowLength(this.prefixTreeEncoder.getRowTokenizer().getMaxElementLength());
        this.prefixTreeEncoder.getRowTokenizer().setNodeFirstInsertionIndexes();
        this.prefixTreeEncoder.getRowTokenizer().appendNodes(this.nonLeaves, true, false);
        this.prefixTreeEncoder.getRowTokenizer().appendNodes(this.leaves, false, true);
        int negativeIndex = 0;
        int totalLeafBytes = 0;
        for (int i = this.leaves.size() - 1; i >= 0; --i) {
            TokenizerNode leaf = this.leaves.get(i);
            RowNodeWriter leafWriter = this.initializeWriter(this.leafWriters, this.numLeafWriters, leaf);
            ++this.numLeafWriters;
            int leafNodeWidth = leafWriter.calculateWidthOverrideOffsetWidth(0);
            totalLeafBytes += leafNodeWidth;
            leaf.setNegativeIndex(negativeIndex += leafNodeWidth);
        }
        int totalNonLeafBytesWithoutOffsets = 0;
        int totalChildPointers = 0;
        for (int i = this.nonLeaves.size() - 1; i >= 0; --i) {
            TokenizerNode nonLeaf = this.nonLeaves.get(i);
            RowNodeWriter nonLeafWriter = this.initializeWriter(this.nonLeafWriters, this.numNonLeafWriters, nonLeaf);
            ++this.numNonLeafWriters;
            totalNonLeafBytesWithoutOffsets += nonLeafWriter.calculateWidthOverrideOffsetWidth(0);
            totalChildPointers += nonLeaf.getNumChildren();
        }
        int offsetWidth = 0;
        while ((long)(totalRowBytes = totalNonLeafBytesWithoutOffsets + (offsetBytes = totalChildPointers * ++offsetWidth) + totalLeafBytes) >= UFIntTool.maxValueForNumBytes(offsetWidth)) {
        }
        this.numBytes = totalRowBytes;
        this.blockMeta.setNextNodeOffsetWidth(offsetWidth);
        for (int i = this.nonLeaves.size() - 1; i >= 0; --i) {
            TokenizerNode nonLeaf = this.nonLeaves.get(i);
            int writerIndex = this.nonLeaves.size() - i - 1;
            RowNodeWriter nonLeafWriter = this.nonLeafWriters.get(writerIndex);
            int nodeWidth = nonLeafWriter.calculateWidth();
            nonLeaf.setNegativeIndex(negativeIndex += nodeWidth);
        }
        return this;
    }

    protected RowNodeWriter initializeWriter(List<RowNodeWriter> list, int index, TokenizerNode builderNode) {
        RowNodeWriter rowNodeWriter = null;
        if (index >= list.size()) {
            list.add(new RowNodeWriter(this.prefixTreeEncoder, builderNode));
        }
        rowNodeWriter = list.get(index);
        rowNodeWriter.reset(builderNode);
        return rowNodeWriter;
    }

    public void writeBytes(OutputStream os) throws IOException {
        int i;
        for (i = this.numNonLeafWriters - 1; i >= 0; --i) {
            RowNodeWriter nonLeafWriter = this.nonLeafWriters.get(i);
            nonLeafWriter.write(os);
        }
        for (i = this.numLeafWriters - 1; i >= 0; --i) {
            RowNodeWriter leafWriter = this.leafWriters.get(i);
            leafWriter.write(os);
        }
    }

    protected static ArrayList<TokenizerNode> filterByLeafAndReverse(ArrayList<TokenizerNode> ins, boolean leaves) {
        ArrayList<TokenizerNode> outs = Lists.newArrayList();
        for (int i = ins.size() - 1; i >= 0; --i) {
            TokenizerNode n = ins.get(i);
            if ((!n.isLeaf() || !leaves) && (n.isLeaf() || leaves)) continue;
            outs.add(ins.get(i));
        }
        return outs;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public ArrayList<TokenizerNode> getNonLeaves() {
        return this.nonLeaves;
    }

    public ArrayList<TokenizerNode> getLeaves() {
        return this.leaves;
    }

    public ArrayList<RowNodeWriter> getNonLeafWriters() {
        return this.nonLeafWriters;
    }

    public ArrayList<RowNodeWriter> getLeafWriters() {
        return this.leafWriters;
    }
}

