/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode;

import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.EncoderPool;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;

@InterfaceAudience.Private
public class EncoderPoolImpl
implements EncoderPool {
    private BlockingQueue<PrefixTreeEncoder> unusedEncoders = new LinkedBlockingQueue<PrefixTreeEncoder>();

    @Override
    public PrefixTreeEncoder checkOut(OutputStream outputStream, boolean includeMvccVersion) {
        PrefixTreeEncoder encoder = (PrefixTreeEncoder)this.unusedEncoders.poll();
        if (encoder == null) {
            encoder = new PrefixTreeEncoder(outputStream, includeMvccVersion);
        } else {
            encoder.reset(outputStream, includeMvccVersion);
        }
        return encoder;
    }

    @Override
    public void checkIn(PrefixTreeEncoder encoder) {
        this.unusedEncoders.add(encoder);
    }
}

