/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.vint.UFIntTool;

@InterfaceAudience.Private
public class TimestampDecoder {
    protected PrefixTreeBlockMeta blockMeta;
    protected byte[] block;

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block) {
        this.block = block;
        this.blockMeta = blockMeta;
    }

    public long getLong(int index) {
        if (this.blockMeta.getTimestampIndexWidth() == 0) {
            return this.blockMeta.getMinTimestamp();
        }
        int startIndex = this.blockMeta.getAbsoluteTimestampOffset() + this.blockMeta.getTimestampDeltaWidth() * index;
        long delta = UFIntTool.fromBytes(this.block, startIndex, this.blockMeta.getTimestampDeltaWidth());
        return this.blockMeta.getMinTimestamp() + delta;
    }
}

