/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Connection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Registry;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ZooKeeperRegistry;

@InterfaceAudience.Private
class RegistryFactory {
    static final String REGISTRY_IMPL_CONF_KEY = "hbase.client.registry.impl";

    RegistryFactory() {
    }

    static Registry getRegistry(Connection connection) throws IOException {
        String registryClass = connection.getConfiguration().get(REGISTRY_IMPL_CONF_KEY, ZooKeeperRegistry.class.getName());
        Registry registry = null;
        try {
            registry = (Registry)Class.forName(registryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        registry.init(connection);
        return registry;
    }
}

