/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.HConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RetryingCallable;

abstract class MasterCallable<V>
implements RetryingCallable<V>,
Closeable {
    protected HConnection connection;
    protected MasterKeepAliveConnection master;

    public MasterCallable(HConnection connection) {
        this.connection = connection;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.master = this.connection.getKeepAliveMasterService();
    }

    @Override
    public void close() throws IOException {
        if (this.master != null) {
            this.master.close();
        }
    }

    @Override
    public void throwable(Throwable t, boolean retrying) {
    }

    @Override
    public String getExceptionMessageAdditionalDetail() {
        return "";
    }

    @Override
    public long sleep(long pause, int tries) {
        return ConnectionUtils.getPauseTime(pause, tries);
    }
}

