/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutorService;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Connection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.User;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ConnectionFactory {
    protected ConnectionFactory() {
    }

    public static Connection createConnection() throws IOException {
        return ConnectionFactory.createConnection(HBaseConfiguration.create(), null, null);
    }

    public static Connection createConnection(Configuration conf) throws IOException {
        return ConnectionFactory.createConnection(conf, null, null);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        return ConnectionFactory.createConnection(conf, pool, null);
    }

    public static Connection createConnection(Configuration conf, User user) throws IOException {
        return ConnectionFactory.createConnection(conf, null, user);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        if (user == null) {
            UserProvider provider = UserProvider.instantiate(conf);
            user = provider.getCurrent();
        }
        return ConnectionFactory.createConnection(conf, false, pool, user);
    }

    static Connection createConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        String className = conf.get("hbase.client.connection.impl", ConnectionManager.HConnectionImplementation.class.getName());
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class, Boolean.TYPE, ExecutorService.class, User.class);
            constructor.setAccessible(true);
            return (Connection)constructor.newInstance(conf, managed, pool, user);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

