/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Addressing;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class ClientIdGenerator {
    private static final Log LOG = LogFactory.getLog(ClientIdGenerator.class);

    ClientIdGenerator() {
    }

    public static byte[] generateClientId() {
        byte[] selfBytes = ClientIdGenerator.getIpAddressBytes();
        Long pid = ClientIdGenerator.getPid();
        long tid = Thread.currentThread().getId();
        long ts = System.currentTimeMillis();
        byte[] id = new byte[selfBytes.length + ((pid != null ? 1 : 0) + 2) * 8];
        int offset = Bytes.putBytes(id, 0, selfBytes, 0, selfBytes.length);
        if (pid != null) {
            offset = Bytes.putLong(id, offset, pid);
        }
        offset = Bytes.putLong(id, offset, tid);
        offset = Bytes.putLong(id, offset, ts);
        assert (offset == id.length);
        return id;
    }

    public static Long getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] nameParts = name.split("@");
        if (nameParts.length == 2) {
            try {
                return Long.parseLong(nameParts[0]);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Failed to get PID from [" + name + "]", ex);
            }
        } else {
            LOG.warn("Don't know how to get PID from [" + name + "]");
        }
        return null;
    }

    public static byte[] getIpAddressBytes() {
        try {
            return Addressing.getIpAddress().getAddress();
        }
        catch (IOException ex) {
            LOG.warn("Failed to get IP address bytes", ex);
            return new byte[0];
        }
    }
}

