/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.CellUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ScanResultCache;

@InterfaceAudience.Private
class AllowPartialScanResultCache
implements ScanResultCache {
    private Cell lastCell;
    private boolean lastResultPartial;
    private int numberOfCompleteRows;

    AllowPartialScanResultCache() {
    }

    private void recordLastResult(Result result) {
        this.lastCell = result.rawCells()[result.rawCells().length - 1];
        this.lastResultPartial = result.mayHaveMoreCellsInRow();
    }

    @Override
    public Result[] addAndGet(Result[] results, boolean isHeartbeatMessage) throws IOException {
        int i;
        if (results.length == 0) {
            if (!isHeartbeatMessage && this.lastResultPartial) {
                ++this.numberOfCompleteRows;
            }
            return EMPTY_RESULT_ARRAY;
        }
        for (i = 0; i < results.length; ++i) {
            Result r = ConnectionUtils.filterCells(results[i], this.lastCell);
            if (r == null) continue;
            results[i] = r;
            break;
        }
        if (i == results.length) {
            return EMPTY_RESULT_ARRAY;
        }
        if (this.lastResultPartial && !CellUtil.matchingRow(this.lastCell, results[0].getRow())) {
            ++this.numberOfCompleteRows;
        }
        this.recordLastResult(results[results.length - 1]);
        if (i > 0) {
            results = Arrays.copyOfRange(results, i, results.length);
        }
        for (Result result : results) {
            if (result.mayHaveMoreCellsInRow()) continue;
            ++this.numberOfCompleteRows;
        }
        return results;
    }

    @Override
    public void clear() {
    }

    @Override
    public int numberOfCompleteRows() {
        return this.numberOfCompleteRows;
    }
}

