/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.CellUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Tag {
    public static final int TYPE_LENGTH_SIZE = 1;
    public static final int TAG_LENGTH_SIZE = 2;
    public static final int INFRASTRUCTURE_SIZE = 3;
    public static final int MAX_TAG_LENGTH = 65533;
    private final byte type;
    private final byte[] bytes;
    private int offset = 0;
    private int length = 0;

    public Tag(byte tagType, String tag) {
        this(tagType, Bytes.toBytes(tag));
    }

    public Tag(byte tagType, byte[] tag) {
        int tagLength = tag.length + 1;
        if (tagLength > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.length = 2 + tagLength;
        this.bytes = new byte[this.length];
        int pos = Bytes.putAsShort(this.bytes, 0, tagLength);
        pos = Bytes.putByte(this.bytes, pos, tagType);
        Bytes.putBytes(this.bytes, pos, tag, 0, tag.length);
        this.type = tagType;
    }

    public Tag(byte[] bytes, int offset) {
        this(bytes, offset, Tag.getLength(bytes, offset));
    }

    private static int getLength(byte[] bytes, int offset) {
        return 2 + Bytes.readAsInt(bytes, offset, 2);
    }

    public Tag(byte[] bytes, int offset, int length) {
        if (length > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.type = bytes[offset + 2];
    }

    public byte[] getBuffer() {
        return this.bytes;
    }

    public byte getType() {
        return this.type;
    }

    public int getTagLength() {
        return this.length - 3;
    }

    public int getTagOffset() {
        return this.offset + 3;
    }

    public byte[] getValue() {
        int tagLength = this.getTagLength();
        byte[] tag = new byte[tagLength];
        Bytes.putBytes(tag, 0, this.bytes, this.getTagOffset(), tagLength);
        return tag;
    }

    public static List<Tag> asList(byte[] b, int offset, int length) {
        int tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos, 2);
            tags.add(new Tag(b, pos, tagLen + 2));
        }
        return tags;
    }

    public static byte[] fromList(List<Tag> tags) {
        if (tags == null || tags.size() <= 0) {
            return null;
        }
        int length = 0;
        for (Tag tag : tags) {
            length += tag.length;
        }
        byte[] b = new byte[length];
        int pos = 0;
        for (Tag tag : tags) {
            System.arraycopy(tag.bytes, tag.offset, b, pos, tag.length);
            pos += tag.length;
        }
        return b;
    }

    public static Tag getTag(byte[] b, int offset, int length, byte type) {
        int tagLen;
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos, 2);
            if (b[pos + 2] != type) continue;
            return new Tag(b, pos, tagLen + 2);
        }
        return null;
    }

    int getLength() {
        return this.length;
    }

    int getOffset() {
        return this.offset;
    }

    public static List<Tag> carryForwardTags(Cell cell) {
        return Tag.carryForwardTags(null, cell);
    }

    public static List<Tag> carryForwardTags(List<Tag> tagsOrNull, Cell cell) {
        List<Tag> tags = tagsOrNull;
        if (cell.getTagsLength() <= 0) {
            return tags;
        }
        Iterator<Tag> itr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        while (itr.hasNext()) {
            tags.add(itr.next());
        }
        return tags;
    }
}

