/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.hbase.shaded.org.apache.commons.collections.map.LinkedMap;
import org.apache.flink.hbase.shaded.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.flink.hbase.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.flink.hbase.shaded.org.apache.commons.configuration.ConfigurationUtils;

public class BaseConfiguration
extends AbstractConfiguration
implements Cloneable {
    private Map store = new LinkedMap();

    protected void addPropertyDirect(String key, Object value) {
        Object previousValue = this.getProperty(key);
        if (previousValue == null) {
            this.store.put(key, value);
        } else if (previousValue instanceof List) {
            ((List)previousValue).add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(previousValue);
            list.add(value);
            this.store.put(key, list);
        }
    }

    public Object getProperty(String key) {
        return this.store.get(key);
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.store.containsKey(key);
    }

    protected void clearPropertyDirect(String key) {
        if (this.containsKey(key)) {
            this.store.remove(key);
        }
    }

    public void clear() {
        this.fireEvent(4, null, null, true);
        this.store.clear();
        this.fireEvent(4, null, null, false);
    }

    public Iterator getKeys() {
        return this.store.keySet().iterator();
    }

    public Object clone() {
        try {
            BaseConfiguration copy = (BaseConfiguration)super.clone();
            copy.store = (Map)ConfigurationUtils.clone(this.store);
            Iterator it = this.store.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (!(e.getValue() instanceof Collection)) continue;
                copy.store.put(e.getKey(), new ArrayList((Collection)e.getValue()));
            }
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }
}

