/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.com.google.common.collect;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.flink.hbase.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hbase.shaded.com.google.common.collect.BstSide;

@GwtCompatible
class BstNode<K, N extends BstNode<K, N>> {
    private final K key;
    @Nullable
    private final N left;
    @Nullable
    private final N right;

    BstNode(@Nullable K key, @Nullable N left, @Nullable N right) {
        this.key = key;
        this.left = left;
        this.right = right;
    }

    @Nullable
    public final K getKey() {
        return this.key;
    }

    @Nullable
    public final N childOrNull(BstSide side) {
        switch (side) {
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
        }
        throw new AssertionError();
    }

    public final boolean hasChild(BstSide side) {
        return this.childOrNull(side) != null;
    }

    public final N getChild(BstSide side) {
        N child = this.childOrNull(side);
        Preconditions.checkState(child != null);
        return child;
    }

    protected final boolean orderingInvariantHolds(Comparator<? super K> comparator) {
        Preconditions.checkNotNull(comparator);
        boolean result = true;
        if (this.hasChild(BstSide.LEFT)) {
            result &= comparator.compare(((BstNode)this.getChild(BstSide.LEFT)).getKey(), this.key) < 0;
        }
        if (this.hasChild(BstSide.RIGHT)) {
            result &= comparator.compare(((BstNode)this.getChild(BstSide.RIGHT)).getKey(), this.key) > 0;
        }
        return result;
    }
}

