/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.sasl.SaslException;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.ZKDatabase;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.ZooKeeperThread;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.AuthFastLeaderElection;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.Election;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.Follower;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.Leader;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.Observer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.QuorumBean;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.QuorumStats;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.RemotePeerBean;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.Vote;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.auth.NullQuorumAuthLearner;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.auth.NullQuorumAuthServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.auth.QuorumAuthLearner;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.auth.SaslQuorumAuthLearner;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.auth.SaslQuorumAuthServer;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.server.util.ZxidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumPeer
extends ZooKeeperThread
implements QuorumStats.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeer.class);
    QuorumBean jmxQuorumBean;
    LocalPeerBean jmxLocalPeerBean;
    LeaderElectionBean jmxLeaderElectionBean;
    QuorumCnxManager qcm;
    QuorumAuthServer authServer;
    QuorumAuthLearner authLearner;
    private boolean authInitialized = false;
    private ZKDatabase zkDb;
    static final long OBSERVER_ID = Long.MAX_VALUE;
    public long start_fle;
    public long end_fle;
    private LearnerType learnerType = LearnerType.PARTICIPANT;
    protected Map<Long, QuorumServer> quorumPeers;
    private QuorumVerifier quorumConfig;
    private long myid;
    private volatile Vote currentVote;
    private volatile Vote bcVote;
    volatile boolean running = true;
    protected int tickTime;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int initLimit;
    protected int syncLimit;
    protected boolean syncEnabled = true;
    protected AtomicInteger tick = new AtomicInteger();
    protected boolean quorumListenOnAllIPs = false;
    protected boolean quorumSaslEnableAuth;
    protected boolean quorumServerSaslAuthRequired;
    protected boolean quorumLearnerSaslAuthRequired;
    protected String quorumServicePrincipal;
    protected String quorumLearnerLoginContext;
    protected String quorumServerLoginContext;
    private static final int QUORUM_CNXN_THREADS_SIZE_DEFAULT_VALUE = 20;
    protected int quorumCnxnThreadsSize = 20;
    private long electionTimeTaken = -1L;
    private ServerState state = ServerState.LOOKING;
    DatagramSocket udpSocket;
    private InetSocketAddress myQuorumAddr;
    private int electionType;
    Election electionAlg;
    ServerCnxnFactory cnxnFactory;
    private FileTxnSnapLog logFactory = null;
    private final QuorumStats quorumStats = new QuorumStats(this);
    ResponderThread responder;
    public Follower follower;
    public Leader leader;
    public Observer observer;
    public static final String SYNC_ENABLED = "zookeeper.observer.syncEnabled";
    private long acceptedEpoch = -1L;
    private long currentEpoch = -1L;
    public static final String CURRENT_EPOCH_FILENAME = "currentEpoch";
    public static final String ACCEPTED_EPOCH_FILENAME = "acceptedEpoch";
    public static final String UPDATING_EPOCH_FILENAME = "updatingEpoch";

    public LearnerType getLearnerType() {
        return this.learnerType;
    }

    public void setLearnerType(LearnerType p) {
        this.learnerType = p;
        if (this.quorumPeers.containsKey(this.myid)) {
            this.quorumPeers.get((Object)Long.valueOf((long)this.myid)).type = p;
        } else {
            LOG.error("Setting LearnerType to " + (Object)((Object)p) + " but " + this.myid + " not in QuorumPeers. ");
        }
    }

    public int getQuorumSize() {
        return this.getVotingView().size();
    }

    @Override
    public long getId() {
        return this.myid;
    }

    public synchronized Vote getCurrentVote() {
        return this.currentVote;
    }

    public synchronized void setCurrentVote(Vote v) {
        this.currentVote = v;
    }

    synchronized Vote getBCVote() {
        if (this.bcVote == null) {
            return this.currentVote;
        }
        return this.bcVote;
    }

    synchronized void setBCVote(Vote v) {
        this.bcVote = v;
    }

    public synchronized void setPeerState(ServerState newState) {
        this.state = newState;
    }

    public synchronized ServerState getPeerState() {
        return this.state;
    }

    public InetSocketAddress getQuorumAddress() {
        return this.myQuorumAddr;
    }

    public static QuorumPeer testingQuorumPeer() throws SaslException {
        return new QuorumPeer();
    }

    protected QuorumPeer() throws SaslException {
        super("QuorumPeer");
        this.initialize();
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, ServerCnxnFactory cnxnFactory) throws IOException {
        this(quorumPeers, dataDir, dataLogDir, electionType, myid, tickTime, initLimit, syncLimit, false, cnxnFactory, new QuorumMaj(QuorumPeer.countParticipants(quorumPeers)));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, boolean quorumListenOnAllIPs, ServerCnxnFactory cnxnFactory, QuorumVerifier quorumConfig) throws IOException {
        this();
        this.cnxnFactory = cnxnFactory;
        this.quorumPeers = quorumPeers;
        this.electionType = electionType;
        this.myid = myid;
        this.tickTime = tickTime;
        this.initLimit = initLimit;
        this.syncLimit = syncLimit;
        this.quorumListenOnAllIPs = quorumListenOnAllIPs;
        this.logFactory = new FileTxnSnapLog(dataLogDir, dataDir);
        this.zkDb = new ZKDatabase(this.logFactory);
        this.quorumConfig = quorumConfig == null ? new QuorumMaj(QuorumPeer.countParticipants(quorumPeers)) : quorumConfig;
    }

    public void initialize() throws SaslException {
        if (this.isQuorumSaslAuthEnabled()) {
            HashSet<String> authzHosts = new HashSet<String>();
            for (QuorumServer qs : this.getView().values()) {
                authzHosts.add(qs.hostname);
            }
            this.authServer = new SaslQuorumAuthServer(this.isQuorumServerSaslAuthRequired(), this.quorumServerLoginContext, authzHosts);
            this.authLearner = new SaslQuorumAuthLearner(this.isQuorumLearnerSaslAuthRequired(), this.quorumServicePrincipal, this.quorumLearnerLoginContext);
            this.authInitialized = true;
        } else {
            this.authServer = new NullQuorumAuthServer();
            this.authLearner = new NullQuorumAuthLearner();
        }
    }

    QuorumStats quorumStats() {
        return this.quorumStats;
    }

    @Override
    public synchronized void start() {
        this.loadDataBase();
        this.cnxnFactory.start();
        this.startLeaderElection();
        super.start();
    }

    private void loadDataBase() {
        File updating = new File(this.getTxnFactory().getSnapDir(), UPDATING_EPOCH_FILENAME);
        try {
            this.zkDb.loadDataBase();
            long lastProcessedZxid = this.zkDb.getDataTree().lastProcessedZxid;
            long epochOfZxid = ZxidUtils.getEpochFromZxid(lastProcessedZxid);
            try {
                this.currentEpoch = this.readLongFromFile(CURRENT_EPOCH_FILENAME);
                if (epochOfZxid > this.currentEpoch && updating.exists()) {
                    LOG.info("{} found. The server was terminated after taking a snapshot but before updating current epoch. Setting current epoch to {}.", (Object)UPDATING_EPOCH_FILENAME, (Object)epochOfZxid);
                    this.setCurrentEpoch(epochOfZxid);
                    if (!updating.delete()) {
                        throw new IOException("Failed to delete " + updating.toString());
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.currentEpoch = epochOfZxid;
                LOG.info("currentEpoch not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)this.currentEpoch);
                this.writeLongToFile(CURRENT_EPOCH_FILENAME, this.currentEpoch);
            }
            if (epochOfZxid > this.currentEpoch) {
                throw new IOException("The current epoch, " + ZxidUtils.zxidToString(this.currentEpoch) + ", is older than the last zxid, " + lastProcessedZxid);
            }
            try {
                this.acceptedEpoch = this.readLongFromFile(ACCEPTED_EPOCH_FILENAME);
            }
            catch (FileNotFoundException e) {
                this.acceptedEpoch = epochOfZxid;
                LOG.info("acceptedEpoch not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)this.acceptedEpoch);
                this.writeLongToFile(ACCEPTED_EPOCH_FILENAME, this.acceptedEpoch);
            }
            if (this.acceptedEpoch < this.currentEpoch) {
                throw new IOException("The accepted epoch, " + ZxidUtils.zxidToString(this.acceptedEpoch) + " is less than the current epoch, " + ZxidUtils.zxidToString(this.currentEpoch));
            }
        }
        catch (IOException ie) {
            LOG.error("Unable to load database on disk", (Throwable)ie);
            throw new RuntimeException("Unable to run quorum server ", ie);
        }
    }

    public synchronized void stopLeaderElection() {
        this.responder.running = false;
        this.responder.interrupt();
    }

    public synchronized void startLeaderElection() {
        try {
            this.currentVote = new Vote(this.myid, this.getLastLoggedZxid(), this.getCurrentEpoch());
        }
        catch (IOException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        for (QuorumServer p : this.getView().values()) {
            if (p.id != this.myid) continue;
            this.myQuorumAddr = p.addr;
            break;
        }
        if (this.myQuorumAddr == null) {
            throw new RuntimeException("My id " + this.myid + " not in the peer list");
        }
        if (this.electionType == 0) {
            try {
                this.udpSocket = new DatagramSocket(this.myQuorumAddr.getPort());
                this.responder = new ResponderThread();
                this.responder.start();
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        this.electionAlg = this.createElectionAlgorithm(this.electionType);
    }

    protected static int countParticipants(Map<Long, QuorumServer> peers) {
        int count = 0;
        for (QuorumServer q : peers.values()) {
            if (q.type != LearnerType.PARTICIPANT) continue;
            ++count;
        }
        return count;
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, false, ServerCnxnFactory.createFactory(new InetSocketAddress(clientPort), -1), new QuorumMaj(QuorumPeer.countParticipants(quorumPeers)));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit, QuorumVerifier quorumConfig) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, false, ServerCnxnFactory.createFactory(new InetSocketAddress(clientPort), -1), quorumConfig);
    }

    public long getLastLoggedZxid() {
        if (!this.zkDb.isInitialized()) {
            this.loadDataBase();
        }
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
        return new Follower(this, new FollowerZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException {
        return new Leader(this, new LeaderZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Observer makeObserver(FileTxnSnapLog logFactory) throws IOException {
        return new Observer(this, new ObserverZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Election createElectionAlgorithm(int electionAlgorithm) {
        Election le = null;
        switch (electionAlgorithm) {
            case 0: {
                le = new LeaderElection(this);
                break;
            }
            case 1: {
                le = new AuthFastLeaderElection(this);
                break;
            }
            case 2: {
                le = new AuthFastLeaderElection(this, true);
                break;
            }
            case 3: {
                this.qcm = this.createCnxnManager();
                QuorumCnxManager.Listener listener = this.qcm.listener;
                if (listener != null) {
                    listener.start();
                    le = new FastLeaderElection(this, this.qcm);
                    break;
                }
                LOG.error("Null listener when initializing cnx manager");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return le;
    }

    protected Election makeLEStrategy() {
        LOG.debug("Initializing leader election protocol...");
        if (this.getElectionType() == 0) {
            this.electionAlg = new LeaderElection(this);
        }
        return this.electionAlg;
    }

    protected synchronized void setLeader(Leader newLeader) {
        this.leader = newLeader;
    }

    protected synchronized void setFollower(Follower newFollower) {
        this.follower = newFollower;
    }

    protected synchronized void setObserver(Observer newObserver) {
        this.observer = newObserver;
    }

    public synchronized ZooKeeperServer getActiveServer() {
        if (this.leader != null) {
            return this.leader.zk;
        }
        if (this.follower != null) {
            return this.follower.zk;
        }
        if (this.observer != null) {
            return this.observer.zk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("QuorumPeer[myid=" + this.getId() + "]" + this.cnxnFactory.getLocalAddress());
        LOG.debug("Starting quorum peer");
        try {
            this.jmxQuorumBean = new QuorumBean(this);
            MBeanRegistry.getInstance().register(this.jmxQuorumBean, null);
            for (QuorumServer s : this.getView().values()) {
                ZKMBeanInfo p;
                if (this.getId() == s.id) {
                    this.jmxLocalPeerBean = new LocalPeerBean(this);
                    p = this.jmxLocalPeerBean;
                    try {
                        MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to register with JMX", (Throwable)e);
                        this.jmxLocalPeerBean = null;
                    }
                    continue;
                }
                p = new RemotePeerBean(s);
                try {
                    MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register with JMX", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.jmxQuorumBean = null;
        }
        try {
            block42: while (this.running) {
                switch (this.getPeerState()) {
                    case LOOKING: {
                        LOG.info("LOOKING");
                        if (Boolean.getBoolean("readonlymode.enabled")) {
                            LOG.info("Attempting to start ReadOnlyZooKeeperServer");
                            final ReadOnlyZooKeeperServer roZk = new ReadOnlyZooKeeperServer(this.logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb);
                            Thread roZkMgr = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        1.sleep(Math.max(2000, QuorumPeer.this.tickTime));
                                        if (ServerState.LOOKING.equals((Object)QuorumPeer.this.getPeerState())) {
                                            roZk.startup();
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        LOG.info("Interrupted while attempting to start ReadOnlyZooKeeperServer, not started");
                                    }
                                    catch (Exception e) {
                                        LOG.error("FAILED to start ReadOnlyZooKeeperServer", (Throwable)e);
                                    }
                                }
                            };
                            try {
                                roZkMgr.start();
                                this.setBCVote(null);
                                this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                                continue block42;
                            }
                            catch (Exception e) {
                                LOG.warn("Unexpected exception", (Throwable)e);
                                this.setPeerState(ServerState.LOOKING);
                                continue block42;
                            }
                            finally {
                                roZkMgr.interrupt();
                                roZk.shutdown();
                                continue block42;
                            }
                        }
                        try {
                            this.setBCVote(null);
                            this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", (Throwable)e);
                            this.setPeerState(ServerState.LOOKING);
                        }
                        break;
                    }
                    case OBSERVING: {
                        try {
                            LOG.info("OBSERVING");
                            this.setObserver(this.makeObserver(this.logFactory));
                            this.observer.observeLeader();
                            continue block42;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", (Throwable)e);
                            continue block42;
                        }
                        finally {
                            this.observer.shutdown();
                            this.setObserver(null);
                            this.setPeerState(ServerState.LOOKING);
                            continue block42;
                        }
                    }
                    case FOLLOWING: {
                        try {
                            LOG.info("FOLLOWING");
                            this.setFollower(this.makeFollower(this.logFactory));
                            this.follower.followLeader();
                            continue block42;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", (Throwable)e);
                            continue block42;
                        }
                        finally {
                            this.follower.shutdown();
                            this.setFollower(null);
                            this.setPeerState(ServerState.LOOKING);
                            continue block42;
                        }
                    }
                    case LEADING: {
                        LOG.info("LEADING");
                        try {
                            this.setLeader(this.makeLeader(this.logFactory));
                            this.leader.lead();
                            this.setLeader(null);
                            continue block42;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", (Throwable)e);
                            continue block42;
                        }
                        finally {
                            if (this.leader != null) {
                                this.leader.shutdown("Forcing shutdown");
                                this.setLeader(null);
                            }
                            this.setPeerState(ServerState.LOOKING);
                            continue block42;
                        }
                    }
                }
            }
        }
        finally {
            LOG.warn("QuorumPeer main thread exited");
            try {
                MBeanRegistry.getInstance().unregisterAll();
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", (Throwable)e);
            }
            this.jmxQuorumBean = null;
            this.jmxLocalPeerBean = null;
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.leader != null) {
            this.leader.shutdown("quorum Peer shutdown");
        }
        if (this.follower != null) {
            this.follower.shutdown();
        }
        this.cnxnFactory.shutdown();
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        if (this.getElectionAlg() != null) {
            this.interrupt();
            this.getElectionAlg().shutdown();
        }
        try {
            this.zkDb.close();
        }
        catch (IOException ie) {
            LOG.warn("Error closing logs ", (Throwable)ie);
        }
    }

    public Map<Long, QuorumServer> getView() {
        return Collections.unmodifiableMap(this.quorumPeers);
    }

    public Map<Long, QuorumServer> getVotingView() {
        return QuorumPeer.viewToVotingView(this.getView());
    }

    static Map<Long, QuorumServer> viewToVotingView(Map<Long, QuorumServer> view) {
        HashMap<Long, QuorumServer> ret = new HashMap<Long, QuorumServer>();
        for (QuorumServer server : view.values()) {
            if (server.type != LearnerType.PARTICIPANT) continue;
            ret.put(server.id, server);
        }
        return ret;
    }

    public Map<Long, QuorumServer> getObservingView() {
        HashMap<Long, QuorumServer> ret = new HashMap<Long, QuorumServer>();
        Map<Long, QuorumServer> view = this.getView();
        for (QuorumServer server : view.values()) {
            if (server.type != LearnerType.OBSERVER) continue;
            ret.put(server.id, server);
        }
        return ret;
    }

    public boolean viewContains(Long sid) {
        return this.quorumPeers.containsKey(sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQuorumPeers() {
        ArrayList<String> l = new ArrayList<String>();
        QuorumPeer quorumPeer = this;
        synchronized (quorumPeer) {
            if (this.leader != null) {
                for (LearnerHandler fh : this.leader.getLearners()) {
                    if (fh.getSocket() == null) continue;
                    String s = fh.getSocket().getRemoteSocketAddress().toString();
                    if (this.leader.isLearnerSynced(fh)) {
                        s = s + "*";
                    }
                    l.add(s);
                }
            } else if (this.follower != null) {
                l.add(this.follower.sock.getRemoteSocketAddress().toString());
            }
        }
        return l.toArray(new String[0]);
    }

    @Override
    public String getServerState() {
        switch (this.getPeerState()) {
            case LOOKING: {
                return "leaderelection";
            }
            case LEADING: {
                return "leading";
            }
            case FOLLOWING: {
                return "following";
            }
            case OBSERVING: {
                return "observing";
            }
        }
        return "unknown";
    }

    public long getMyid() {
        return this.myid;
    }

    public void setMyid(long myid) {
        this.myid = myid;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to " + tickTime);
        this.tickTime = tickTime;
    }

    public int getMaxClientCnxnsPerHost() {
        ServerCnxnFactory fac = this.getCnxnFactory();
        if (fac == null) {
            return -1;
        }
        return fac.getMaxClientCnxnsPerHost();
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min) {
        LOG.info("minSessionTimeout set to " + min);
        this.minSessionTimeout = min;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max) {
        LOG.info("maxSessionTimeout set to " + max);
        this.maxSessionTimeout = max;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public void setInitLimit(int initLimit) {
        LOG.info("initLimit set to " + initLimit);
        this.initLimit = initLimit;
    }

    public int getTick() {
        return this.tick.get();
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumConfig;
    }

    public void setQuorumVerifier(QuorumVerifier quorumConfig) {
        this.quorumConfig = quorumConfig;
    }

    public Election getElectionAlg() {
        return this.electionAlg;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public void setSyncLimit(int syncLimit) {
        this.syncLimit = syncLimit;
    }

    public boolean getSyncEnabled() {
        if (System.getProperty(SYNC_ENABLED) != null) {
            LOG.info("zookeeper.observer.syncEnabled=" + Boolean.getBoolean(SYNC_ENABLED));
            return Boolean.getBoolean(SYNC_ENABLED);
        }
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    public int getElectionType() {
        return this.electionType;
    }

    public void setElectionType(int electionType) {
        this.electionType = electionType;
    }

    public boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public void setQuorumListenOnAllIPs(boolean quorumListenOnAllIPs) {
        this.quorumListenOnAllIPs = quorumListenOnAllIPs;
    }

    public ServerCnxnFactory getCnxnFactory() {
        return this.cnxnFactory;
    }

    public void setCnxnFactory(ServerCnxnFactory cnxnFactory) {
        this.cnxnFactory = cnxnFactory;
    }

    public void setQuorumPeers(Map<Long, QuorumServer> quorumPeers) {
        this.quorumPeers = quorumPeers;
    }

    public int getClientPort() {
        return this.cnxnFactory.getLocalPort();
    }

    public void setClientPortAddress(InetSocketAddress addr) {
    }

    public void setTxnFactory(FileTxnSnapLog factory) {
        this.logFactory = factory;
    }

    public FileTxnSnapLog getTxnFactory() {
        return this.logFactory;
    }

    public void setZKDatabase(ZKDatabase database) {
        this.zkDb = database;
    }

    protected ZKDatabase getZkDb() {
        return this.zkDb;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public QuorumCnxManager getQuorumCnxManager() {
        return this.qcm;
    }

    private long readLongFromFile(String name) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), name);
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = "";
        try {
            line = br.readLine();
            long l = Long.parseLong(line);
            return l;
        }
        catch (NumberFormatException e) {
            throw new IOException("Found " + line + " in " + file);
        }
        finally {
            br.close();
        }
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="Stream will be eventually closed in abort()")
    private void writeLongToFile(String name, long value) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), name);
        AtomicFileOutputStream out = new AtomicFileOutputStream(file);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        boolean aborted = false;
        try {
            bw.write(Long.toString(value));
            bw.flush();
            out.flush();
        }
        catch (IOException e) {
            LOG.error("Failed to write new file " + file, (Throwable)e);
            aborted = true;
            out.abort();
            throw e;
        }
        finally {
            if (!aborted) {
                out.close();
            }
        }
    }

    public long getCurrentEpoch() throws IOException {
        if (this.currentEpoch == -1L) {
            this.currentEpoch = this.readLongFromFile(CURRENT_EPOCH_FILENAME);
        }
        return this.currentEpoch;
    }

    public long getAcceptedEpoch() throws IOException {
        if (this.acceptedEpoch == -1L) {
            this.acceptedEpoch = this.readLongFromFile(ACCEPTED_EPOCH_FILENAME);
        }
        return this.acceptedEpoch;
    }

    public void setCurrentEpoch(long e) throws IOException {
        this.currentEpoch = e;
        this.writeLongToFile(CURRENT_EPOCH_FILENAME, e);
    }

    public void setAcceptedEpoch(long e) throws IOException {
        this.acceptedEpoch = e;
        this.writeLongToFile(ACCEPTED_EPOCH_FILENAME, e);
    }

    protected void updateElectionVote(long newEpoch) {
        Vote currentVote = this.getCurrentVote();
        this.setBCVote(currentVote);
        if (currentVote != null) {
            this.setCurrentVote(new Vote(currentVote.getId(), currentVote.getZxid(), currentVote.getElectionEpoch(), newEpoch, currentVote.getState()));
        }
    }

    void setQuorumServerSaslRequired(boolean serverSaslRequired) {
        this.quorumServerSaslAuthRequired = serverSaslRequired;
        LOG.info("{} set to {}", (Object)"quorum.auth.serverRequireSasl", (Object)serverSaslRequired);
    }

    void setQuorumLearnerSaslRequired(boolean learnerSaslRequired) {
        this.quorumLearnerSaslAuthRequired = learnerSaslRequired;
        LOG.info("{} set to {}", (Object)"quorum.auth.learnerRequireSasl", (Object)learnerSaslRequired);
    }

    void setQuorumSaslEnabled(boolean enableAuth) {
        this.quorumSaslEnableAuth = enableAuth;
        if (!this.quorumSaslEnableAuth) {
            LOG.info("QuorumPeer communication is not secured!");
        } else {
            LOG.info("{} set to {}", (Object)"quorum.auth.enableSasl", (Object)enableAuth);
        }
    }

    void setQuorumServicePrincipal(String servicePrincipal) {
        this.quorumServicePrincipal = servicePrincipal;
        LOG.info("{} set to {}", (Object)"quorum.auth.kerberos.servicePrincipal", (Object)this.quorumServicePrincipal);
    }

    void setQuorumLearnerLoginContext(String learnerContext) {
        this.quorumLearnerLoginContext = learnerContext;
        LOG.info("{} set to {}", (Object)"quorum.auth.learner.saslLoginContext", (Object)this.quorumLearnerLoginContext);
    }

    void setQuorumServerLoginContext(String serverContext) {
        this.quorumServerLoginContext = serverContext;
        LOG.info("{} set to {}", (Object)"quorum.auth.server.saslLoginContext", (Object)this.quorumServerLoginContext);
    }

    void setQuorumCnxnThreadsSize(int qCnxnThreadsSize) {
        if (qCnxnThreadsSize > 20) {
            this.quorumCnxnThreadsSize = qCnxnThreadsSize;
        }
        LOG.info("quorum.cnxn.threads.size set to {}", (Object)this.quorumCnxnThreadsSize);
    }

    boolean isQuorumSaslAuthEnabled() {
        return this.quorumSaslEnableAuth;
    }

    private boolean isQuorumServerSaslAuthRequired() {
        return this.quorumServerSaslAuthRequired;
    }

    private boolean isQuorumLearnerSaslAuthRequired() {
        return this.quorumLearnerSaslAuthRequired;
    }

    public boolean hasAuthInitialized() {
        return this.authInitialized;
    }

    public QuorumCnxManager createCnxnManager() {
        return new QuorumCnxManager(this.getId(), this.getView(), this.authServer, this.authLearner, this.tickTime * this.syncLimit, this.getQuorumListenOnAllIPs(), this.quorumCnxnThreadsSize, this.isQuorumSaslAuthEnabled());
    }

    void setElectionTimeTaken(long electionTimeTaken) {
        this.electionTimeTaken = electionTimeTaken;
    }

    long getElectionTimeTaken() {
        return this.electionTimeTaken;
    }

    @Deprecated
    class ResponderThread
    extends ZooKeeperThread {
        volatile boolean running;

        ResponderThread() {
            super("ResponderThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] b = new byte[36];
                ByteBuffer responseBuffer = ByteBuffer.wrap(b);
                DatagramPacket packet = new DatagramPacket(b, b.length);
                while (this.running) {
                    QuorumPeer.this.udpSocket.receive(packet);
                    if (packet.getLength() != 4) {
                        LOG.warn("Got more than just an xid! Len = " + packet.getLength());
                    } else {
                        responseBuffer.clear();
                        responseBuffer.getInt();
                        responseBuffer.putLong(QuorumPeer.this.myid);
                        Vote current = QuorumPeer.this.getCurrentVote();
                        switch (QuorumPeer.this.getPeerState()) {
                            case LOOKING: {
                                responseBuffer.putLong(current.getId());
                                responseBuffer.putLong(current.getZxid());
                                break;
                            }
                            case LEADING: {
                                responseBuffer.putLong(QuorumPeer.this.myid);
                                try {
                                    long proposed;
                                    Leader leader = QuorumPeer.this.leader;
                                    synchronized (leader) {
                                        proposed = QuorumPeer.this.leader.lastProposed;
                                    }
                                    responseBuffer.putLong(proposed);
                                }
                                catch (NullPointerException nullPointerException) {}
                                break;
                            }
                            case FOLLOWING: {
                                responseBuffer.putLong(current.getId());
                                try {
                                    responseBuffer.putLong(QuorumPeer.this.follower.getZxid());
                                }
                                catch (NullPointerException nullPointerException) {}
                                break;
                            }
                        }
                        packet.setData(b);
                        QuorumPeer.this.udpSocket.send(packet);
                    }
                    packet.setLength(b.length);
                }
            }
            catch (RuntimeException e) {
                LOG.warn("Unexpected runtime exception in ResponderThread", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("Unexpected IO exception in ResponderThread", (Throwable)e);
            }
            finally {
                LOG.warn("QuorumPeer responder thread exited");
            }
        }
    }

    public static enum LearnerType {
        PARTICIPANT,
        OBSERVER;

    }

    public static enum ServerState {
        LOOKING,
        FOLLOWING,
        LEADING,
        OBSERVING;

    }

    public static class QuorumServer {
        public InetSocketAddress addr;
        public InetSocketAddress electionAddr;
        public String hostname;
        public int port = 2888;
        public int electionPort = -1;
        public long id;
        public LearnerType type = LearnerType.PARTICIPANT;

        private QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = electionAddr;
        }

        public QuorumServer(long id, InetSocketAddress addr) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = null;
        }

        private QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr, LearnerType type) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = electionAddr;
            this.type = type;
        }

        public QuorumServer(long id, String hostname, Integer port, Integer electionPort, LearnerType type) {
            this.id = id;
            this.hostname = hostname;
            if (port != null) {
                this.port = port;
            }
            if (electionPort != null) {
                this.electionPort = electionPort;
            }
            if (type != null) {
                this.type = type;
            }
            this.recreateSocketAddresses();
        }

        public void recreateSocketAddresses() {
            block7: {
                InetAddress address = null;
                try {
                    int ipReachableTimeout = 0;
                    String ipReachableValue = System.getProperty("zookeeper.ipReachableTimeout");
                    if (ipReachableValue != null) {
                        try {
                            ipReachableTimeout = Integer.parseInt(ipReachableValue);
                        }
                        catch (NumberFormatException e) {
                            LOG.error("{} is not a valid number", (Object)ipReachableValue);
                        }
                    }
                    address = ipReachableTimeout <= 0 ? InetAddress.getByName(this.hostname) : this.getReachableAddress(this.hostname, ipReachableTimeout);
                    LOG.info("Resolved hostname: {} to address: {}", (Object)this.hostname, (Object)address);
                    this.addr = new InetSocketAddress(address, this.port);
                    if (this.electionPort > 0) {
                        this.electionAddr = new InetSocketAddress(address, this.electionPort);
                    }
                }
                catch (UnknownHostException ex) {
                    LOG.warn("Failed to resolve address: {}", (Object)this.hostname, (Object)ex);
                    if (this.addr != null) {
                        return;
                    }
                    this.addr = InetSocketAddress.createUnresolved(this.hostname, this.port);
                    if (this.electionPort <= 0) break block7;
                    this.electionAddr = InetSocketAddress.createUnresolved(this.hostname, this.electionPort);
                }
            }
        }

        public InetAddress getReachableAddress(String hostname, int timeout) throws UnknownHostException {
            InetAddress[] addresses;
            for (InetAddress a : addresses = InetAddress.getAllByName(hostname)) {
                try {
                    if (!a.isReachable(timeout)) continue;
                    return a;
                }
                catch (IOException e) {
                    LOG.warn("IP address {} is unreachable", (Object)a);
                }
            }
            return addresses[0];
        }
    }
}

