/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.flink.hbase.shaded.org.apache.commons.cli.BasicParser;
import org.apache.flink.hbase.shaded.org.apache.commons.cli.CommandLine;
import org.apache.flink.hbase.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.flink.hbase.shaded.org.apache.commons.cli.Option;
import org.apache.flink.hbase.shaded.org.apache.commons.cli.Options;
import org.apache.flink.hbase.shaded.org.apache.commons.cli.ParseException;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public abstract class AbstractHBaseTool
implements Tool {
    protected static final int EXIT_SUCCESS = 0;
    protected static final int EXIT_FAILURE = 1;
    private static final Option HELP_OPTION = new Option("h", "help", false, "Prints help for this tool.");
    private static final Log LOG = LogFactory.getLog(AbstractHBaseTool.class);
    private final Options options = new Options();
    protected Configuration conf = null;
    protected String[] cmdLineArgs = null;

    protected abstract void addOptions();

    protected abstract void processOptions(CommandLine var1);

    protected abstract int doWork() throws Exception;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public final int run(String[] args) throws IOException {
        int ret;
        CommandLine cmd;
        this.cmdLineArgs = args;
        if (this.conf == null) {
            LOG.error("Tool configuration is not initialized");
            throw new NullPointerException("conf");
        }
        try {
            this.addOptions();
            if (this.isHelpCommand(args)) {
                this.printUsage();
                return 0;
            }
            cmd = new BasicParser().parse(this.options, args);
        }
        catch (ParseException e) {
            LOG.error("Error when parsing command-line arguments", e);
            this.printUsage();
            return 1;
        }
        this.processOptions(cmd);
        try {
            ret = this.doWork();
        }
        catch (Exception e) {
            LOG.error("Error running command-line tool", e);
            return 1;
        }
        return ret;
    }

    private boolean isHelpCommand(String[] args) throws ParseException {
        Options helpOption = new Options().addOption(HELP_OPTION);
        CommandLine cl = new BasicParser().parse(helpOption, args, true);
        return cl.getOptions().length != 0;
    }

    protected void printUsage() {
        this.printUsage("bin/hbase " + this.getClass().getName() + " <options>", "Options:", "");
    }

    protected void printUsage(String usageStr, String usageHeader, String usageFooter) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(120);
        helpFormatter.printHelp(usageStr, usageHeader, this.options, usageFooter);
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
    }

    protected void addRequiredOptWithArg(String opt, String description) {
        Option option = new Option(opt, true, description);
        option.setRequired(true);
        this.options.addOption(option);
    }

    protected void addRequiredOptWithArg(String shortOpt, String longOpt, String description) {
        Option option = new Option(shortOpt, longOpt, true, description);
        option.setRequired(true);
        this.options.addOption(option);
    }

    protected void addOptNoArg(String opt, String description) {
        this.options.addOption(opt, false, description);
    }

    protected void addOptNoArg(String shortOpt, String longOpt, String description) {
        this.options.addOption(shortOpt, longOpt, false, description);
    }

    protected void addOptWithArg(String opt, String description) {
        this.options.addOption(opt, true, description);
    }

    protected void addOptWithArg(String shortOpt, String longOpt, String description) {
        this.options.addOption(shortOpt, longOpt, true, description);
    }

    public int getOptionAsInt(CommandLine cmd, String opt, int defaultValue) {
        if (cmd.hasOption(opt)) {
            return Integer.parseInt(cmd.getOptionValue(opt));
        }
        return defaultValue;
    }

    public double getOptionAsDouble(CommandLine cmd, String opt, double defaultValue) {
        if (cmd.hasOption(opt)) {
            return Double.parseDouble(cmd.getOptionValue(opt));
        }
        return defaultValue;
    }

    public static long parseLong(String s, long minValue, long maxValue) {
        long l = Long.parseLong(s);
        if (l < minValue || l > maxValue) {
            throw new IllegalArgumentException("The value " + l + " is out of range [" + minValue + ", " + maxValue + "]");
        }
        return l;
    }

    public static int parseInt(String s, int minValue, int maxValue) {
        return (int)AbstractHBaseTool.parseLong(s, minValue, maxValue);
    }

    protected void doStaticMain(String[] args) {
        int ret;
        try {
            ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)this, (String[])args);
        }
        catch (Exception ex) {
            LOG.error("Error running command-line tool", ex);
            ret = 1;
        }
        System.exit(ret);
    }
}

