/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase1.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.options.HBaseLookupOptions;
import org.apache.flink.connector.hbase.source.AbstractHBaseDynamicTableSource;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase1.source.HBaseRowDataInputFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseDynamicTableSource
extends AbstractHBaseDynamicTableSource {
    public HBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral, HBaseLookupOptions lookupOptions) {
        super(conf, tableName, hbaseSchema, nullStringLiteral, lookupOptions);
    }

    public DynamicTableSource copy() {
        return new HBaseDynamicTableSource(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.lookupOptions);
    }

    @Override
    public InputFormat<RowData, ?> getInputFormat() {
        return new HBaseRowDataInputFormat(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral);
    }

    @VisibleForTesting
    public HBaseLookupOptions getLookupOptions() {
        return this.lookupOptions;
    }
}

