/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
public enum ChecksumType {
    NULL(0){

        @Override
        public String getName() {
            return "NULL";
        }

        @Override
        public DataChecksum.Type getDataChecksumType() {
            return DataChecksum.Type.NULL;
        }
    }
    ,
    CRC32(1){

        @Override
        public String getName() {
            return "CRC32";
        }

        @Override
        public DataChecksum.Type getDataChecksumType() {
            return DataChecksum.Type.CRC32;
        }
    }
    ,
    CRC32C(2){

        @Override
        public String getName() {
            return "CRC32C";
        }

        @Override
        public DataChecksum.Type getDataChecksumType() {
            return DataChecksum.Type.CRC32C;
        }
    };

    private final byte code;

    public static ChecksumType getDefaultChecksumType() {
        return CRC32C;
    }

    public abstract String getName();

    public abstract DataChecksum.Type getDataChecksumType();

    private ChecksumType(byte c) {
        this.code = c;
    }

    public byte getCode() {
        return this.code;
    }

    public static ChecksumType codeToType(byte b) {
        for (ChecksumType t : ChecksumType.values()) {
            if (t.getCode() != b) continue;
            return t;
        }
        throw new RuntimeException("Unknown checksum type code " + b);
    }

    public static ChecksumType nameToType(String name) {
        for (ChecksumType t : ChecksumType.values()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        throw new RuntimeException("Unknown checksum type name " + name);
    }
}

