/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Order;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedInt16
extends OrderedBytesBase<Short> {
    public static final OrderedInt16 ASCENDING = new OrderedInt16(Order.ASCENDING);
    public static final OrderedInt16 DESCENDING = new OrderedInt16(Order.DESCENDING);

    protected OrderedInt16(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Short val) {
        return 3;
    }

    @Override
    public Class<Short> encodedClass() {
        return Short.class;
    }

    @Override
    public Short decode(PositionedByteRange src) {
        return OrderedBytes.decodeInt16(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Short val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeInt16(dst, val, this.order);
    }

    public short decodeShort(PositionedByteRange src) {
        return OrderedBytes.decodeInt16(src);
    }

    public int encodeShort(PositionedByteRange dst, short val) {
        return OrderedBytes.encodeInt16(dst, val, this.order);
    }
}

