/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Order;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedBlob
extends OrderedBytesBase<byte[]> {
    public static final OrderedBlob ASCENDING = new OrderedBlob(Order.ASCENDING);
    public static final OrderedBlob DESCENDING = new OrderedBlob(Order.DESCENDING);

    protected OrderedBlob(Order order) {
        super(order);
    }

    @Override
    public boolean isSkippable() {
        return false;
    }

    @Override
    public int encodedLength(byte[] val) {
        return null == val ? (Order.ASCENDING == this.order ? 1 : 2) : (Order.ASCENDING == this.order ? val.length + 1 : val.length + 2);
    }

    @Override
    public Class<byte[]> encodedClass() {
        return byte[].class;
    }

    @Override
    public byte[] decode(PositionedByteRange src) {
        return OrderedBytes.decodeBlobCopy(src);
    }

    @Override
    public int encode(PositionedByteRange dst, byte[] val) {
        return OrderedBytes.encodeBlobCopy(dst, val, this.order);
    }

    public int encode(PositionedByteRange dst, byte[] val, int voff, int vlen) {
        return OrderedBytes.encodeBlobCopy(dst, val, voff, vlen, this.order);
    }
}

