/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.flink.hbase.shaded.io.netty.channel.Channel;
import org.apache.flink.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.flink.hbase.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.hbase.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.flink.hbase.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcClient
extends AbstractRpcClient<NettyRpcConnection> {
    final EventLoopGroup group;
    final Class<? extends Channel> channelClass;
    private final boolean shutdownGroupWhenClose;

    public NettyRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        super(configuration, clusterId, localAddress, metrics);
        Pair<EventLoopGroup, Class<? extends Channel>> groupAndChannelClass = NettyRpcClientConfigHelper.getEventLoopConfig(this.conf);
        if (groupAndChannelClass == null) {
            this.group = new NioEventLoopGroup(0, new DefaultThreadFactory("IPC-NioEventLoopGroup", true, 10));
            this.channelClass = NioSocketChannel.class;
            this.shutdownGroupWhenClose = true;
        } else {
            this.group = groupAndChannelClass.getFirst();
            this.channelClass = groupAndChannelClass.getSecond();
            this.shutdownGroupWhenClose = false;
        }
    }

    NettyRpcClient(Configuration configuration) {
        this(configuration, "default-cluster", null, null);
    }

    @Override
    protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
        return new NettyRpcConnection(this, remoteId);
    }

    @Override
    protected void closeInternal() {
        if (this.shutdownGroupWhenClose) {
            this.group.shutdownGracefully();
        }
    }
}

