/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.security.User;

@InterfaceAudience.Private
public class ConnectionId {
    private static final int PRIME = 16777619;
    final User ticket;
    final String serviceName;
    final InetSocketAddress address;

    public ConnectionId(User ticket, String serviceName, InetSocketAddress address) {
        this.address = address;
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public User getTicket() {
        return this.ticket;
    }

    public String toString() {
        return this.address.toString() + "/" + this.serviceName + "/" + this.ticket;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.ticket == null ? 0 : this.ticket.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionId other = (ConnectionId)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.ticket == null ? other.ticket != null : !this.ticket.equals(other.ticket));
    }

    public static int hashCode(User ticket, String serviceName, InetSocketAddress address) {
        return address.hashCode() + 16777619 * (16777619 * serviceName.hashCode() ^ (ticket == null ? 0 : ticket.hashCode()));
    }
}

