/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ReversedScannerCallable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class ReversedClientScanner
extends ClientScanner {
    public ReversedClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
    }

    @Override
    protected boolean setNewStartKey() {
        if (ConnectionUtils.noMoreResultsForReverseScan(this.scan, this.currentRegion)) {
            return false;
        }
        this.scan.withStartRow(this.currentRegion.getStartKey(), false);
        return true;
    }

    @Override
    protected ReversedScannerCallable createScannerCallable() {
        return new ReversedScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory);
    }
}

