/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Cancellable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.flink.hbase.shaded.org.apache.htrace.Trace;

@InterfaceAudience.Private
public class ResultBoundedCompletionService<V> {
    private static final Log LOG = LogFactory.getLog(ResultBoundedCompletionService.class);
    private final RpcRetryingCallerFactory retryingCallerFactory;
    private final Executor executor;
    private final QueueingFuture<V>[] tasks;
    private final ArrayList<QueueingFuture> completedTasks;
    private volatile boolean cancelled = false;

    public ResultBoundedCompletionService(RpcRetryingCallerFactory retryingCallerFactory, Executor executor, int maxTasks) {
        this.retryingCallerFactory = retryingCallerFactory;
        this.executor = executor;
        this.tasks = new QueueingFuture[maxTasks];
        this.completedTasks = new ArrayList(maxTasks);
    }

    public void submit(RetryingCallable<V> task, int callTimeout, int id) {
        QueueingFuture<V> newFuture = new QueueingFuture<V>(task, callTimeout, id);
        this.executor.execute(Trace.wrap(newFuture));
        this.tasks[id] = newFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueingFuture<V> take() throws InterruptedException {
        QueueingFuture<V>[] queueingFutureArray = this.tasks;
        synchronized (this.tasks) {
            while (!this.cancelled && this.completedTasks.size() < 1) {
                this.tasks.wait();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.completedTasks.get(0);
        }
    }

    public QueueingFuture<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollForSpecificCompletedTask(timeout, unit, 0);
    }

    public QueueingFuture<V> pollForFirstSuccessfullyCompletedTask(long timeout, TimeUnit unit, int startIndex, int endIndex) throws InterruptedException, CancellationException, ExecutionException {
        for (int i = startIndex; i < endIndex; ++i) {
            long start = EnvironmentEdgeManager.currentTime();
            QueueingFuture<V> f = this.pollForSpecificCompletedTask(timeout, unit, i);
            long duration = EnvironmentEdgeManager.currentTime() - start;
            timeout -= duration;
            if (f == null) {
                return null;
            }
            if (f.getExeEx() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Replica " + (f == null ? 0 : f.getReplicaId()) + " returns " + f.getExeEx().getCause());
                }
                if (i != endIndex - 1) continue;
                throw f.getExeEx();
            }
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueingFuture<V> pollForSpecificCompletedTask(long timeout, TimeUnit unit, int index) throws InterruptedException {
        if (index < 0) {
            return null;
        }
        QueueingFuture<V>[] queueingFutureArray = this.tasks;
        synchronized (this.tasks) {
            if (!this.cancelled && this.completedTasks.size() <= index) {
                unit.timedWait(this.tasks, timeout);
            }
            if (this.completedTasks.size() <= index) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return this.completedTasks.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        QueueingFuture<V>[] queueingFutureArray = this.tasks;
        synchronized (this.tasks) {
            this.cancelled = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (QueueingFuture<V> future : this.tasks) {
                if (future == null) continue;
                future.cancel(true);
            }
            return;
        }
    }

    class QueueingFuture<T>
    implements RunnableFuture<T> {
        private final RetryingCallable<T> future;
        private T result = null;
        private ExecutionException exeEx = null;
        private volatile boolean cancelled = false;
        private final int callTimeout;
        private final RpcRetryingCaller<T> retryingCaller;
        private boolean resultObtained = false;
        private final int replicaId;

        public QueueingFuture(RetryingCallable<T> future, int callTimeout, int id) {
            this.future = future;
            this.callTimeout = callTimeout;
            this.retryingCaller = ResultBoundedCompletionService.this.retryingCallerFactory.newCaller();
            this.replicaId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!this.cancelled) {
                    this.result = this.retryingCaller.callWithRetries(this.future, this.callTimeout);
                    this.resultObtained = true;
                }
            }
            catch (Throwable t) {
                this.exeEx = new ExecutionException(t);
            }
            finally {
                QueueingFuture[] queueingFutureArray = ResultBoundedCompletionService.this.tasks;
                synchronized (queueingFutureArray) {
                    if (!this.cancelled) {
                        ResultBoundedCompletionService.this.completedTasks.add(this);
                    }
                    ResultBoundedCompletionService.this.tasks.notify();
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.resultObtained || this.exeEx != null) {
                return false;
            }
            this.retryingCaller.cancel();
            if (this.future instanceof Cancellable) {
                ((Cancellable)((Object)this.future)).cancel();
            }
            this.cancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.resultObtained || this.exeEx != null;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.get(1000L, TimeUnit.DAYS);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("You did wait for 1000 days here?", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            QueueingFuture[] queueingFutureArray = ResultBoundedCompletionService.this.tasks;
            synchronized (queueingFutureArray) {
                if (this.resultObtained) {
                    return this.result;
                }
                if (this.exeEx != null) {
                    throw this.exeEx;
                }
                unit.timedWait(ResultBoundedCompletionService.this.tasks, timeout);
            }
            if (this.resultObtained) {
                return this.result;
            }
            if (this.exeEx != null) {
                throw this.exeEx;
            }
            throw new TimeoutException("timeout=" + timeout + ", " + (Object)((Object)unit));
        }

        public int getReplicaId() {
            return this.replicaId;
        }

        public ExecutionException getExeEx() {
            return this.exeEx;
        }
    }
}

