/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class ClientSimpleScanner
extends ClientScanner {
    public ClientSimpleScanner(Configuration configuration, Scan scan, TableName name, ClusterConnection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, int replicaCallTimeoutMicroSecondScan) throws IOException {
        super(configuration, scan, name, connection, rpcCallerFactory, rpcControllerFactory, pool, replicaCallTimeoutMicroSecondScan);
    }

    @Override
    protected boolean setNewStartKey() {
        if (ConnectionUtils.noMoreResultsForScan(this.scan, this.currentRegion)) {
            return false;
        }
        this.scan.withStartRow(this.currentRegion.getEndKey(), true);
        return true;
    }

    @Override
    protected ScannerCallable createScannerCallable() {
        if (!this.scan.includeStartRow() && !ConnectionUtils.isEmptyStartRow(this.scan.getStartRow())) {
            this.scan.withStartRow(ConnectionUtils.createClosestRowAfter(this.scan.getStartRow()), true);
        }
        return new ScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory);
    }
}

