/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.com.google.common.collect;

import java.lang.reflect.Array;
import org.apache.flink.hbase.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.hbase.shaded.com.google.common.annotations.GwtIncompatible;
import org.apache.flink.hbase.shaded.com.google.common.collect.MapMaker;

@GwtCompatible(emulated=true)
class Platform {
    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    static <T> T[] newArray(T[] reference, int length) {
        Class<?> type = reference.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, length);
        return result;
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    private Platform() {
    }
}

