/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase1;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.hbase.options.HBaseOptions;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase1.sink.HBaseDynamicTableSink;
import org.apache.flink.connector.hbase1.source.HBaseDynamicTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hadoop.conf.Configuration;

public class HBase1DynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final String IDENTIFIER = "hbase-1.4";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        Map options = context.getCatalogTable().getOptions();
        HBaseOptions.validatePrimaryKey(tableSchema);
        String tableName = (String)tableOptions.get(HBaseOptions.TABLE_NAME);
        Configuration hbaseClientConf = HBaseOptions.getHBaseConfiguration(options);
        String nullStringLiteral = (String)tableOptions.get(HBaseOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(tableSchema);
        return new HBaseDynamicTableSource(hbaseClientConf, tableName, hbaseSchema, nullStringLiteral, HBaseOptions.getHBaseLookupOptions(tableOptions));
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        Map options = context.getCatalogTable().getOptions();
        HBaseOptions.validatePrimaryKey(tableSchema);
        String tableName = (String)tableOptions.get(HBaseOptions.TABLE_NAME);
        Configuration hbaseConf = HBaseOptions.getHBaseConfiguration(options);
        HBaseWriteOptions hBaseWriteOptions = HBaseOptions.getHBaseWriteOptions(tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(tableSchema);
        return new HBaseDynamicTableSink(tableName, hbaseSchema, hbaseConf, hBaseWriteOptions, nullStringLiteral);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(HBaseOptions.TABLE_NAME);
        set.add(HBaseOptions.ZOOKEEPER_QUORUM);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(HBaseOptions.ZOOKEEPER_ZNODE_PARENT);
        set.add(HBaseOptions.NULL_STRING_LITERAL);
        set.add(HBaseOptions.SINK_BUFFER_FLUSH_MAX_SIZE);
        set.add(HBaseOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        set.add(HBaseOptions.SINK_BUFFER_FLUSH_INTERVAL);
        set.add(FactoryUtil.SINK_PARALLELISM);
        set.add(HBaseOptions.LOOKUP_CACHE_MAX_ROWS);
        set.add(HBaseOptions.LOOKUP_CACHE_TTL);
        set.add(HBaseOptions.LOOKUP_MAX_RETRIES);
        return set;
    }
}

