/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;

@PublicEvolving
public class HBase
extends ConnectorDescriptor {
    private DescriptorProperties properties = new DescriptorProperties();

    public HBase() {
        super("hbase", 1, false);
    }

    public HBase version(String version) {
        this.properties.putString("connector.version", version);
        return this;
    }

    public HBase tableName(String tableName) {
        this.properties.putString("connector.table-name", tableName);
        return this;
    }

    public HBase zookeeperQuorum(String zookeeperQuorum) {
        this.properties.putString("connector.zookeeper.quorum", zookeeperQuorum);
        return this;
    }

    public HBase zookeeperNodeParent(String zookeeperNodeParent) {
        this.properties.putString("connector.zookeeper.znode.parent", zookeeperNodeParent);
        return this;
    }

    public HBase writeBufferFlushMaxSize(String maxSize) {
        this.properties.putMemorySize("connector.write.buffer-flush.max-size", MemorySize.parse((String)maxSize, (MemorySize.MemoryUnit)MemorySize.MemoryUnit.BYTES));
        return this;
    }

    public HBase writeBufferFlushMaxRows(int writeBufferFlushMaxRows) {
        this.properties.putInt("connector.write.buffer-flush.max-rows", writeBufferFlushMaxRows);
        return this;
    }

    public HBase writeBufferFlushInterval(String interval) {
        this.properties.putString("connector.write.buffer-flush.interval", interval);
        return this;
    }

    protected Map<String, String> toConnectorProperties() {
        return this.properties.asMap();
    }
}

