/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class WeakObjectPool<K, V> {
    private final ReferenceQueue<V> staleRefQueue = new ReferenceQueue();
    private final ObjectFactory<K, V> objectFactory;
    private final ConcurrentMap<K, ObjectReference> referenceCache;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;

    public WeakObjectPool(ObjectFactory<K, V> objectFactory) {
        this(objectFactory, 16, 16);
    }

    public WeakObjectPool(ObjectFactory<K, V> objectFactory, int initialCapacity) {
        this(objectFactory, initialCapacity, 16);
    }

    public WeakObjectPool(ObjectFactory<K, V> objectFactory, int initialCapacity, int concurrencyLevel) {
        if (objectFactory == null) {
            throw new NullPointerException();
        }
        this.objectFactory = objectFactory;
        this.referenceCache = new ConcurrentHashMap<K, ObjectReference>(initialCapacity, 0.75f, concurrencyLevel);
    }

    public void purge() {
        ObjectReference ref;
        while ((ref = (ObjectReference)this.staleRefQueue.poll()) != null) {
            this.referenceCache.remove(ref.key, ref);
        }
    }

    public V get(K key) {
        ObjectReference ref = (ObjectReference)this.referenceCache.get(key);
        if (ref != null) {
            Object obj = ref.get();
            if (obj != null) {
                return (V)obj;
            }
            this.referenceCache.remove(key, ref);
        }
        V newObj = this.objectFactory.createObject(key);
        ObjectReference newRef = new ObjectReference(key, newObj);
        ObjectReference existingRef;
        while ((existingRef = this.referenceCache.putIfAbsent(key, newRef)) != null) {
            Object existingObject = existingRef.get();
            if (existingObject != null) {
                return (V)existingObject;
            }
            this.referenceCache.remove(key, existingRef);
        }
        return newObj;
    }

    public int size() {
        return this.referenceCache.size();
    }

    private class ObjectReference
    extends WeakReference<V> {
        final K key;

        ObjectReference(K key, V obj) {
            super(obj, WeakObjectPool.this.staleRefQueue);
            this.key = key;
        }
    }

    public static interface ObjectFactory<K, V> {
        public V createObject(K var1);
    }
}

