/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.procedure2;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.procedure2.ProcedureRunnableSet;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureSimpleRunQueue
implements ProcedureRunnableSet {
    private final Deque<Procedure> runnables = new ArrayDeque<Procedure>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitCond = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFront(Procedure proc) {
        this.lock.lock();
        try {
            this.runnables.addFirst(proc);
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBack(Procedure proc) {
        this.lock.lock();
        try {
            this.runnables.addLast(proc);
            this.waitCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void yield(Procedure proc) {
        this.addBack(proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public Procedure poll() {
        block8: {
            this.lock.lock();
            try {
                if (this.runnables.isEmpty()) {
                    this.waitCond.await();
                    if (!this.runnables.isEmpty()) {
                        Procedure procedure = this.runnables.pop();
                        return procedure;
                    }
                    break block8;
                }
                Procedure procedure = this.runnables.pop();
                return procedure;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Procedure procedure = null;
                return procedure;
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAll() {
        this.lock.lock();
        try {
            this.waitCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.runnables.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.runnables.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void completionCleanup(Procedure proc) {
    }
}

