/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.vint.UFIntTool;

@InterfaceAudience.Private
public class MvccVersionDecoder {
    protected PrefixTreeBlockMeta blockMeta;
    protected byte[] block;

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block) {
        this.block = block;
        this.blockMeta = blockMeta;
    }

    public long getMvccVersion(int index) {
        if (this.blockMeta.getMvccVersionIndexWidth() == 0) {
            return this.blockMeta.getMinMvccVersion();
        }
        int startIndex = this.blockMeta.getAbsoluteMvccVersionOffset() + this.blockMeta.getMvccVersionDeltaWidth() * index;
        long delta = UFIntTool.fromBytes(this.block, startIndex, this.blockMeta.getMvccVersionDeltaWidth());
        return this.blockMeta.getMinMvccVersion() + delta;
    }
}

