/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.CellComparator;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.CellScanner;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeCell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.column.ColumnReader;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.row.RowNodeReader;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp.MvccVersionDecoder;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp.TimestampDecoder;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.codec.prefixtree.encode.other.ColumnNodeType;

@InterfaceAudience.Private
public class PrefixTreeArrayScanner
extends PrefixTreeCell
implements CellScanner {
    protected PrefixTreeBlockMeta blockMeta;
    protected boolean beforeFirst;
    protected boolean afterLast;
    protected RowNodeReader[] rowNodes;
    protected int rowNodeStackIndex;
    protected RowNodeReader currentRowNode;
    protected ColumnReader familyReader;
    protected ColumnReader qualifierReader;
    protected ColumnReader tagsReader;
    protected TimestampDecoder timestampDecoder;
    protected MvccVersionDecoder mvccVersionDecoder;
    protected boolean nubCellsRemain;
    protected int currentCellIndex;

    public PrefixTreeArrayScanner(PrefixTreeBlockMeta blockMeta, int rowTreeDepth, int rowBufferLength, int qualifierBufferLength, int tagsBufferLength) {
        this.rowNodes = new RowNodeReader[rowTreeDepth];
        for (int i = 0; i < this.rowNodes.length; ++i) {
            this.rowNodes[i] = new RowNodeReader();
        }
        this.rowBuffer = new byte[rowBufferLength];
        this.familyBuffer = new byte[127];
        this.familyReader = new ColumnReader(this.familyBuffer, ColumnNodeType.FAMILY);
        this.qualifierBuffer = new byte[qualifierBufferLength];
        this.tagsBuffer = new byte[tagsBufferLength];
        this.qualifierReader = new ColumnReader(this.qualifierBuffer, ColumnNodeType.QUALIFIER);
        this.tagsReader = new ColumnReader(this.tagsBuffer, ColumnNodeType.TAGS);
        this.timestampDecoder = new TimestampDecoder();
        this.mvccVersionDecoder = new MvccVersionDecoder();
    }

    public boolean areBuffersBigEnough() {
        if (this.rowNodes.length < this.blockMeta.getRowTreeDepth()) {
            return false;
        }
        if (this.rowBuffer.length < this.blockMeta.getMaxRowLength()) {
            return false;
        }
        if (this.qualifierBuffer.length < this.blockMeta.getMaxQualifierLength()) {
            return false;
        }
        return this.tagsBuffer.length >= this.blockMeta.getMaxTagsLength();
    }

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block, boolean includeMvccVersion) {
        this.block = block;
        this.blockMeta = blockMeta;
        this.familyOffset = this.familyBuffer.length;
        this.familyReader.initOnBlock(blockMeta, block);
        this.qualifierOffset = this.qualifierBuffer.length;
        this.qualifierReader.initOnBlock(blockMeta, block);
        this.tagsOffset = this.tagsBuffer.length;
        this.tagsReader.initOnBlock(blockMeta, block);
        this.timestampDecoder.initOnBlock(blockMeta, block);
        this.mvccVersionDecoder.initOnBlock(blockMeta, block);
        this.includeMvccVersion = includeMvccVersion;
        this.resetToBeforeFirstEntry();
    }

    public void resetToBeforeFirstEntry() {
        this.beforeFirst = true;
        this.afterLast = false;
        this.rowNodeStackIndex = -1;
        this.currentRowNode = null;
        this.rowLength = 0;
        this.familyOffset = this.familyBuffer.length;
        this.familyLength = 0;
        this.qualifierOffset = this.blockMeta.getMaxQualifierLength();
        this.qualifierLength = 0;
        this.nubCellsRemain = false;
        this.currentCellIndex = -1;
        this.timestamp = -1L;
        this.type = DEFAULT_TYPE;
        this.absoluteValueOffset = 0;
        this.valueLength = 0;
        this.tagsOffset = this.blockMeta.getMaxTagsLength();
        this.tagsLength = 0;
    }

    public void releaseBlockReference() {
        this.block = null;
    }

    @Override
    public Cell current() {
        if (this.isOutOfBounds()) {
            return null;
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        Cell currentCell = this.current();
        if (currentCell == null) {
            return "null";
        }
        return ((PrefixTreeCell)currentCell).getKeyValueString();
    }

    public boolean positionAtFirstCell() {
        this.reInitFirstNode();
        return this.advance();
    }

    @Override
    public boolean advance() {
        if (this.afterLast) {
            return false;
        }
        if (!this.hasOccurrences()) {
            this.resetToBeforeFirstEntry();
        }
        if (this.beforeFirst || this.isLastCellInRow()) {
            this.nextRow();
            if (this.afterLast) {
                return false;
            }
        } else {
            ++this.currentCellIndex;
        }
        this.populateNonRowFields(this.currentCellIndex);
        return true;
    }

    public boolean nextRow() {
        this.nextRowInternal();
        if (this.afterLast) {
            return false;
        }
        this.populateNonRowFields(this.currentCellIndex);
        return true;
    }

    protected boolean nextRowInternal() {
        if (this.afterLast) {
            return false;
        }
        if (this.beforeFirst) {
            this.initFirstNode();
            if (this.currentRowNode.hasOccurrences()) {
                if (this.currentRowNode.isNub()) {
                    this.nubCellsRemain = true;
                }
                this.currentCellIndex = 0;
                return true;
            }
        }
        if (this.currentRowNode.isLeaf()) {
            this.discardCurrentRowNode(true);
        }
        while (!this.afterLast) {
            if (this.nubCellsRemain) {
                this.nubCellsRemain = false;
            }
            if (this.currentRowNode.hasMoreFanNodes()) {
                this.followNextFan();
                if (!this.currentRowNode.hasOccurrences()) continue;
                this.currentCellIndex = 0;
                return true;
            }
            this.discardCurrentRowNode(true);
        }
        return false;
    }

    protected void reInitFirstNode() {
        this.resetToBeforeFirstEntry();
        this.initFirstNode();
    }

    protected void initFirstNode() {
        int offsetIntoUnderlyingStructure = this.blockMeta.getAbsoluteRowOffset();
        this.rowNodeStackIndex = 0;
        this.currentRowNode = this.rowNodes[0];
        this.currentRowNode.initOnBlock(this.blockMeta, this.block, offsetIntoUnderlyingStructure);
        this.appendCurrentTokenToRowBuffer();
        this.beforeFirst = false;
    }

    protected void followFirstFan() {
        this.followFan(0);
    }

    protected void followPreviousFan() {
        int nextFanPosition = this.currentRowNode.getFanIndex() - 1;
        this.followFan(nextFanPosition);
    }

    protected void followCurrentFan() {
        int currentFanPosition = this.currentRowNode.getFanIndex();
        this.followFan(currentFanPosition);
    }

    protected void followNextFan() {
        int nextFanPosition = this.currentRowNode.getFanIndex() + 1;
        this.followFan(nextFanPosition);
    }

    protected void followLastFan() {
        this.followFan(this.currentRowNode.getLastFanIndex());
    }

    protected void followFan(int fanIndex) {
        this.currentRowNode.setFanIndex(fanIndex);
        this.appendToRowBuffer(this.currentRowNode.getFanByte(fanIndex));
        int nextOffsetIntoUnderlyingStructure = this.currentRowNode.getOffset() + this.currentRowNode.getNextNodeOffset(fanIndex, this.blockMeta);
        ++this.rowNodeStackIndex;
        this.currentRowNode = this.rowNodes[this.rowNodeStackIndex];
        this.currentRowNode.initOnBlock(this.blockMeta, this.block, nextOffsetIntoUnderlyingStructure);
        this.appendCurrentTokenToRowBuffer();
        if (this.currentRowNode.isNub()) {
            this.nubCellsRemain = true;
        }
        this.currentCellIndex = 0;
    }

    protected void discardCurrentRowNode(boolean forwards) {
        RowNodeReader rowNodeBeingPopped = this.currentRowNode;
        --this.rowNodeStackIndex;
        if (this.rowNodeStackIndex < 0) {
            this.currentRowNode = null;
            if (forwards) {
                this.markAfterLast();
            } else {
                this.markBeforeFirst();
            }
            return;
        }
        this.popFromRowBuffer(rowNodeBeingPopped);
        this.currentRowNode = this.rowNodes[this.rowNodeStackIndex];
    }

    protected void markBeforeFirst() {
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRowNode = null;
    }

    protected void markAfterLast() {
        this.beforeFirst = false;
        this.afterLast = true;
        this.currentRowNode = null;
    }

    protected void appendCurrentTokenToRowBuffer() {
        System.arraycopy(this.block, this.currentRowNode.getTokenArrayOffset(), this.rowBuffer, this.rowLength, this.currentRowNode.getTokenLength());
        this.rowLength += this.currentRowNode.getTokenLength();
    }

    protected void appendToRowBuffer(byte b) {
        this.rowBuffer[this.rowLength] = b;
        ++this.rowLength;
    }

    protected void popFromRowBuffer(RowNodeReader rowNodeBeingPopped) {
        this.rowLength -= rowNodeBeingPopped.getTokenLength();
        --this.rowLength;
    }

    protected boolean hasOccurrences() {
        return this.currentRowNode != null && this.currentRowNode.hasOccurrences();
    }

    protected boolean isBranch() {
        return this.currentRowNode != null && !this.currentRowNode.hasOccurrences() && this.currentRowNode.hasChildren();
    }

    protected boolean isNub() {
        return this.currentRowNode != null && this.currentRowNode.hasOccurrences() && this.currentRowNode.hasChildren();
    }

    protected boolean isLeaf() {
        return this.currentRowNode != null && this.currentRowNode.hasOccurrences() && !this.currentRowNode.hasChildren();
    }

    public boolean isBeforeFirst() {
        return this.beforeFirst;
    }

    public boolean isAfterLast() {
        return this.afterLast;
    }

    protected boolean isOutOfBounds() {
        return this.beforeFirst || this.afterLast;
    }

    protected boolean isFirstCellInRow() {
        return this.currentCellIndex == 0;
    }

    protected boolean isLastCellInRow() {
        return this.currentCellIndex == this.currentRowNode.getLastCellIndex();
    }

    protected int populateNonRowFieldsAndCompareTo(int cellNum, Cell key) {
        this.populateNonRowFields(cellNum);
        return CellComparator.compare(this, key, true);
    }

    protected void populateFirstNonRowFields() {
        this.populateNonRowFields(0);
    }

    protected void populatePreviousNonRowFields() {
        this.populateNonRowFields(this.currentCellIndex - 1);
    }

    protected void populateLastNonRowFields() {
        this.populateNonRowFields(this.currentRowNode.getLastCellIndex());
    }

    protected void populateNonRowFields(int cellIndex) {
        this.currentCellIndex = cellIndex;
        this.populateFamily();
        this.populateQualifier();
        if (this.blockMeta.getNumTagsBytes() != 0) {
            this.populateTag();
        }
        this.populateTimestamp();
        this.populateMvccVersion();
        this.populateType();
        this.populateValueOffsets();
    }

    protected void populateFamily() {
        int familyTreeIndex = this.currentRowNode.getFamilyOffset(this.currentCellIndex, this.blockMeta);
        this.familyOffset = this.familyReader.populateBuffer(familyTreeIndex).getColumnOffset();
        this.familyLength = this.familyReader.getColumnLength();
    }

    protected void populateQualifier() {
        int qualifierTreeIndex = this.currentRowNode.getColumnOffset(this.currentCellIndex, this.blockMeta);
        this.qualifierOffset = this.qualifierReader.populateBuffer(qualifierTreeIndex).getColumnOffset();
        this.qualifierLength = this.qualifierReader.getColumnLength();
    }

    protected void populateTag() {
        int tagTreeIndex = this.currentRowNode.getTagOffset(this.currentCellIndex, this.blockMeta);
        this.tagsOffset = this.tagsReader.populateBuffer(tagTreeIndex).getColumnOffset();
        this.tagsLength = this.tagsReader.getColumnLength();
    }

    protected void populateTimestamp() {
        if (this.blockMeta.isAllSameTimestamp()) {
            this.timestamp = this.blockMeta.getMinTimestamp();
        } else {
            int timestampIndex = this.currentRowNode.getTimestampIndex(this.currentCellIndex, this.blockMeta);
            this.timestamp = this.timestampDecoder.getLong(timestampIndex);
        }
    }

    protected void populateMvccVersion() {
        if (this.blockMeta.isAllSameMvccVersion()) {
            this.mvccVersion = this.blockMeta.getMinMvccVersion();
        } else {
            int mvccVersionIndex = this.currentRowNode.getMvccVersionIndex(this.currentCellIndex, this.blockMeta);
            this.mvccVersion = this.mvccVersionDecoder.getMvccVersion(mvccVersionIndex);
        }
    }

    protected void populateType() {
        int typeInt = this.blockMeta.isAllSameType() ? this.blockMeta.getAllTypes() : this.currentRowNode.getType(this.currentCellIndex, this.blockMeta);
        this.type = PrefixTreeCell.TYPES[typeInt];
    }

    protected void populateValueOffsets() {
        int offsetIntoValueSection = this.currentRowNode.getValueOffset(this.currentCellIndex, this.blockMeta);
        this.absoluteValueOffset = this.blockMeta.getAbsoluteValueOffset() + offsetIntoValueSection;
        this.valueLength = this.currentRowNode.getValueLength(this.currentCellIndex, this.blockMeta);
    }

    public byte[] getTreeBytes() {
        return this.block;
    }

    public PrefixTreeBlockMeta getBlockMeta() {
        return this.blockMeta;
    }

    public int getMaxRowTreeStackNodes() {
        return this.rowNodes.length;
    }

    public int getRowBufferLength() {
        return this.rowBuffer.length;
    }

    public int getQualifierBufferLength() {
        return this.qualifierBuffer.length;
    }

    public int getTagBufferLength() {
        return this.tagsBuffer.length;
    }
}

