/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.hbase.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.flink.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.flink.hbase.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.hbase.shaded.io.netty.channel.ChannelOption;
import org.apache.flink.hbase.shaded.io.netty.channel.EventLoopGroup;
import org.apache.flink.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.hbase.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.hbase.shaded.io.netty.channel.socket.DatagramChannel;
import org.apache.flink.hbase.shaded.io.netty.channel.socket.DatagramPacket;
import org.apache.flink.hbase.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ClusterStatus;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ServerName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Addressing;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
class ClusterStatusListener
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ClusterStatusListener.class);
    private final List<ServerName> deadServers = new ArrayList<ServerName>();
    protected final DeadServerHandler deadServerHandler;
    private final Listener listener;
    public static final String STATUS_LISTENER_CLASS = "hbase.status.listener.class";
    public static final Class<? extends Listener> DEFAULT_STATUS_LISTENER_CLASS = MulticastListener.class;

    public ClusterStatusListener(DeadServerHandler dsh, Configuration conf, Class<? extends Listener> listenerClass) throws IOException {
        this.deadServerHandler = dsh;
        try {
            Constructor<? extends Listener> ctor = listenerClass.getConstructor(ClusterStatusListener.class);
            this.listener = ctor.newInstance(this);
        }
        catch (InstantiationException e) {
            throw new IOException("Can't create listener " + listenerClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Can't create listener " + listenerClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException();
        }
        this.listener.connect(conf);
    }

    public void receive(ClusterStatus ncs) {
        if (ncs.getDeadServerNames() != null) {
            for (ServerName sn : ncs.getDeadServerNames()) {
                if (this.isDeadServer(sn)) continue;
                LOG.info("There is a new dead server: " + sn);
                this.deadServers.add(sn);
                if (this.deadServerHandler == null) continue;
                this.deadServerHandler.newDead(sn);
            }
        }
    }

    @Override
    public void close() {
        this.listener.close();
    }

    public boolean isDeadServer(ServerName sn) {
        if (sn.getStartcode() <= 0L) {
            return false;
        }
        for (ServerName dead : this.deadServers) {
            if (dead.getStartcode() < sn.getStartcode() || dead.getPort() != sn.getPort() || !dead.getHostname().equals(sn.getHostname())) continue;
            return true;
        }
        return false;
    }

    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    class MulticastListener
    implements Listener {
        private DatagramChannel channel;
        private final EventLoopGroup group = new NioEventLoopGroup(1, Threads.newDaemonThreadFactory("hbase-client-clusterStatusListener"));

        @Override
        public void connect(Configuration conf) throws IOException {
            InetAddress ina;
            String mcAddress = conf.get("hbase.status.multicast.address.ip", "226.1.1.3");
            String bindAddress = conf.get("hbase.status.multicast.bind.address.ip", "0.0.0.0");
            int port = conf.getInt("hbase.status.multicast.address.port", 16100);
            try {
                ina = InetAddress.getByName(mcAddress);
            }
            catch (UnknownHostException e) {
                this.close();
                throw new IOException("Can't connect to " + mcAddress, e);
            }
            try {
                Bootstrap b = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, true)).handler(new ClusterStatusHandler());
                this.channel = (DatagramChannel)b.bind(bindAddress, port).sync().channel();
            }
            catch (InterruptedException e) {
                this.close();
                throw ExceptionUtil.asInterrupt(e);
            }
            NetworkInterface ni = NetworkInterface.getByInetAddress(Addressing.getIpAddress());
            this.channel.joinGroup(ina, ni, null, this.channel.newPromise());
        }

        @Override
        public void close() {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.group.shutdownGracefully();
        }

        private class ClusterStatusHandler
        extends SimpleChannelInboundHandler<DatagramPacket> {
            private ClusterStatusHandler() {
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                LOG.error("Unexpected exception, continuing.", cause);
            }

            @Override
            public boolean acceptInboundMessage(Object msg) throws Exception {
                return super.acceptInboundMessage(msg);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket dp) throws Exception {
                try (ByteBufInputStream bis = new ByteBufInputStream((ByteBuf)dp.content());){
                    ClusterStatusProtos.ClusterStatus csp = ClusterStatusProtos.ClusterStatus.parseFrom(bis);
                    ClusterStatus ncs = ClusterStatus.convert(csp);
                    ClusterStatusListener.this.receive(ncs);
                }
            }
        }
    }

    static interface Listener
    extends Closeable {
        @Override
        public void close();

        public void connect(Configuration var1) throws IOException;
    }

    public static interface DeadServerHandler {
        public void newDead(ServerName var1);
    }
}

