/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.com.google.common.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.hbase.shaded.com.google.common.base.Joiner;
import org.apache.flink.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hbase.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.hbase.shaded.com.google.common.collect.Maps;
import org.apache.flink.hbase.shaded.com.google.common.collect.Sets;
import org.apache.flink.hbase.shaded.com.google.common.reflect.Types;

class TypeResolver {
    private final ImmutableMap<TypeVariable<?>, Type> typeTable;

    static TypeResolver accordingTo(Type type) {
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(type));
    }

    TypeResolver() {
        this.typeTable = ImmutableMap.of();
    }

    private TypeResolver(ImmutableMap<TypeVariable<?>, Type> typeTable) {
        this.typeTable = typeTable;
    }

    final TypeResolver where(Map<? extends TypeVariable<?>, ? extends Type> mappings) {
        ImmutableMap.Builder<TypeVariable<?>, Type> builder = ImmutableMap.builder();
        builder.putAll(this.typeTable);
        for (Map.Entry<TypeVariable<?>, Type> mapping : mappings.entrySet()) {
            Type type;
            TypeVariable<?> variable = mapping.getKey();
            Preconditions.checkArgument(!variable.equals(type = mapping.getValue()), "Type variable %s bound to itself", variable);
            builder.put(variable, type);
        }
        return new TypeResolver(builder.build());
    }

    final TypeResolver where(Type mapFrom, Type mapTo) {
        HashMap<TypeVariable<?>, Type> mappings = Maps.newHashMap();
        TypeResolver.populateTypeMappings(mappings, mapFrom, mapTo);
        return this.where(mappings);
    }

    private static void populateTypeMappings(Map<TypeVariable<?>, Type> mappings, Type from, Type to) {
        if (from instanceof TypeVariable) {
            mappings.put((TypeVariable)from, to);
        } else if (from instanceof GenericArrayType) {
            TypeResolver.populateTypeMappings(mappings, ((GenericArrayType)from).getGenericComponentType(), Types.getComponentType(to));
        } else if (from instanceof ParameterizedType) {
            Type[] toArgs;
            Type[] fromArgs = ((ParameterizedType)from).getActualTypeArguments();
            Preconditions.checkArgument(fromArgs.length == (toArgs = ((ParameterizedType)to).getActualTypeArguments()).length);
            for (int i = 0; i < fromArgs.length; ++i) {
                TypeResolver.populateTypeMappings(mappings, fromArgs[i], toArgs[i]);
            }
        }
    }

    final Type resolve(Type type) {
        if (type instanceof TypeVariable) {
            return this.resolveTypeVariable((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new Types.WildcardTypeImpl(this.resolve(wildcardType.getLowerBounds()), this.resolve(wildcardType.getUpperBounds()));
        }
        return type;
    }

    private Type[] resolve(Type[] types) {
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.resolve(types[i]);
        }
        return result;
    }

    private Type resolveGenericArrayType(GenericArrayType type) {
        Type componentType = this.resolve(type.getGenericComponentType());
        return Types.newArrayType(componentType);
    }

    private Type resolveTypeVariable(final TypeVariable<?> var) {
        final TypeResolver unguarded = this;
        TypeResolver guarded = new TypeResolver(this.typeTable){

            @Override
            Type resolveTypeVariable(TypeVariable<?> intermediateVar, TypeResolver guardedResolver) {
                if (intermediateVar.getGenericDeclaration().equals(var.getGenericDeclaration())) {
                    return intermediateVar;
                }
                return unguarded.resolveTypeVariable(intermediateVar, guardedResolver);
            }
        };
        return this.resolveTypeVariable(var, guarded);
    }

    Type resolveTypeVariable(TypeVariable<?> var, TypeResolver guardedResolver) {
        Type type = this.typeTable.get(var);
        if (type == null) {
            Type[] bounds = var.getBounds();
            if (bounds.length == 0) {
                return var;
            }
            return Types.newTypeVariable(var.getGenericDeclaration(), var.getName(), guardedResolver.resolve(bounds));
        }
        return guardedResolver.resolve(type);
    }

    private ParameterizedType resolveParameterizedType(ParameterizedType type) {
        Type owner = type.getOwnerType();
        Type resolvedOwner = owner == null ? null : this.resolve(owner);
        Type resolvedRawType = this.resolve(type.getRawType());
        Type[] vars = type.getActualTypeArguments();
        Type[] resolvedArgs = new Type[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            resolvedArgs[i] = this.resolve(vars[i]);
        }
        return Types.newParameterizedTypeWithOwner(resolvedOwner, (Class)resolvedRawType, resolvedArgs);
    }

    private static final class WildcardCapturer {
        private final AtomicInteger id = new AtomicInteger();

        private WildcardCapturer() {
        }

        Type capture(Type type) {
            Preconditions.checkNotNull(type);
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                return type;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                return Types.newArrayType(this.capture(arrayType.getGenericComponentType()));
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return Types.newParameterizedTypeWithOwner(this.captureNullable(parameterizedType.getOwnerType()), (Class)parameterizedType.getRawType(), this.capture(parameterizedType.getActualTypeArguments()));
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds.length == 0) {
                    Object[] upperBounds = wildcardType.getUpperBounds();
                    String name = "capture#" + this.id.incrementAndGet() + "-of ? extends " + Joiner.on('&').join(upperBounds);
                    return Types.newTypeVariable(WildcardCapturer.class, name, wildcardType.getUpperBounds());
                }
                return type;
            }
            throw new AssertionError((Object)"must have been one of the known types");
        }

        private Type captureNullable(@Nullable Type type) {
            if (type == null) {
                return null;
            }
            return this.capture(type);
        }

        private Type[] capture(Type[] types) {
            Type[] result = new Type[types.length];
            for (int i = 0; i < types.length; ++i) {
                result[i] = this.capture(types[i]);
            }
            return result;
        }
    }

    private static final class TypeMappingIntrospector {
        private static final WildcardCapturer wildcardCapturer = new WildcardCapturer();
        private final Map<TypeVariable<?>, Type> mappings = Maps.newHashMap();
        private final Set<Type> introspectedTypes = Sets.newHashSet();

        private TypeMappingIntrospector() {
        }

        static ImmutableMap<TypeVariable<?>, Type> getTypeMappings(Type contextType) {
            TypeMappingIntrospector introspector = new TypeMappingIntrospector();
            introspector.introspect(wildcardCapturer.capture(contextType));
            return ImmutableMap.copyOf(introspector.mappings);
        }

        private void introspect(Type type) {
            block4: {
                block6: {
                    block5: {
                        block3: {
                            if (!this.introspectedTypes.add(type)) {
                                return;
                            }
                            if (!(type instanceof ParameterizedType)) break block3;
                            this.introspectParameterizedType((ParameterizedType)type);
                            break block4;
                        }
                        if (!(type instanceof Class)) break block5;
                        this.introspectClass((Class)type);
                        break block4;
                    }
                    if (!(type instanceof TypeVariable)) break block6;
                    for (Type bound : ((TypeVariable)type).getBounds()) {
                        this.introspect(bound);
                    }
                    break block4;
                }
                if (!(type instanceof WildcardType)) break block4;
                for (Type bound : ((WildcardType)type).getUpperBounds()) {
                    this.introspect(bound);
                }
            }
        }

        private void introspectClass(Class<?> clazz) {
            this.introspect(clazz.getGenericSuperclass());
            for (Type interfaceType : clazz.getGenericInterfaces()) {
                this.introspect(interfaceType);
            }
        }

        private void introspectParameterizedType(ParameterizedType parameterizedType) {
            Type[] typeArgs;
            Class rawClass = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] vars = rawClass.getTypeParameters();
            Preconditions.checkState(vars.length == (typeArgs = parameterizedType.getActualTypeArguments()).length);
            for (int i = 0; i < vars.length; ++i) {
                this.map(vars[i], typeArgs[i]);
            }
            this.introspectClass(rawClass);
            this.introspect(parameterizedType.getOwnerType());
        }

        private void map(TypeVariable<?> var, Type arg) {
            if (this.mappings.containsKey(var)) {
                return;
            }
            Type t = arg;
            while (t != null) {
                if (var.equals(t)) {
                    Type x = arg;
                    while (x != null) {
                        x = this.mappings.remove(x);
                    }
                    return;
                }
                t = this.mappings.get(t);
            }
            this.mappings.put(var, arg);
        }
    }
}

