/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.zookeeper.server.upgrade;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.jute.Index;
import org.apache.flink.hbase.shaded.org.apache.jute.InputArchive;
import org.apache.flink.hbase.shaded.org.apache.jute.OutputArchive;
import org.apache.flink.hbase.shaded.org.apache.jute.Record;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.data.ACL;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.flink.hbase.shaded.org.apache.zookeeper.data.StatPersistedV1;

public class DataNodeV1
implements Record {
    DataNodeV1 parent;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    byte[] data;
    public List<ACL> acl;
    public StatPersistedV1 stat;
    HashSet<String> children = new HashSet();

    DataNodeV1() {
    }

    DataNodeV1(DataNodeV1 parent, byte[] data, List<ACL> acl, StatPersistedV1 stat) {
        this.parent = parent;
        this.data = data;
        this.acl = acl;
        this.stat = stat;
        this.children = new HashSet();
    }

    public void setChildren(HashSet<String> children) {
        this.children = children;
    }

    public HashSet<String> getChildren() {
        return this.children;
    }

    public void copyStat(Stat to) {
        to.setAversion(this.stat.getAversion());
        to.setCtime(this.stat.getCtime());
        to.setCversion(this.stat.getCversion());
        to.setCzxid(this.stat.getCzxid());
        to.setMtime(this.stat.getMtime());
        to.setMzxid(this.stat.getMzxid());
        to.setVersion(this.stat.getVersion());
        to.setEphemeralOwner(this.stat.getEphemeralOwner());
        to.setDataLength(this.data.length);
        to.setNumChildren(this.children.size());
    }

    @Override
    public void deserialize(InputArchive archive, String tag) throws IOException {
        archive.startRecord("node");
        this.data = archive.readBuffer("data");
        Index i = archive.startVector("acl");
        if (i != null) {
            this.acl = new ArrayList<ACL>();
            while (!i.done()) {
                ACL a = new ACL();
                a.deserialize(archive, "aclEntry");
                this.acl.add(a);
                i.incr();
            }
        }
        archive.endVector("acl");
        this.stat = new StatPersistedV1();
        this.stat.deserialize(archive, "stat");
        archive.endRecord("node");
    }

    @Override
    public synchronized void serialize(OutputArchive archive, String tag) throws IOException {
        archive.startRecord(this, "node");
        archive.writeBuffer(this.data, "data");
        archive.startVector(this.acl, "acl");
        if (this.acl != null) {
            for (ACL a : this.acl) {
                a.serialize(archive, "aclEntry");
            }
        }
        archive.endVector(this.acl, "acl");
        this.stat.serialize(archive, "stat");
        archive.endRecord(this, "node");
    }
}

