/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.htrace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.flink.hbase.shaded.org.apache.htrace.Span;
import org.apache.flink.hbase.shaded.org.apache.htrace.Tracer;
import org.apache.flink.hbase.shaded.org.apache.htrace.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.htrace.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.htrace.impl.MilliSpan;

public class TraceTree {
    public static final Log LOG = LogFactory.getLog(Tracer.class);
    private final SpansByParent spansByParent;
    private final SpansByProcessId spansByProcessId;

    public TraceTree(Collection<Span> spans) {
        this.spansByParent = new SpansByParent(spans);
        this.spansByProcessId = new SpansByProcessId(spans);
    }

    public SpansByParent getSpansByParent() {
        return this.spansByParent;
    }

    public SpansByProcessId getSpansByProcessId() {
        return this.spansByProcessId;
    }

    public static class SpansByProcessId {
        private static Comparator<Span> COMPARATOR = new Comparator<Span>(){

            @Override
            public int compare(Span a, Span b) {
                int cmp = a.getProcessId().compareTo(b.getProcessId());
                if (cmp != 0) {
                    return cmp;
                }
                if (a.getSpanId() < b.getSpanId()) {
                    return -1;
                }
                if (a.getSpanId() > b.getSpanId()) {
                    return 1;
                }
                return 0;
            }
        };
        private final TreeSet<Span> treeSet;

        SpansByProcessId(Collection<Span> spans) {
            TreeSet<Span> treeSet = new TreeSet<Span>(COMPARATOR);
            for (Span span : spans) {
                treeSet.add(span);
            }
            this.treeSet = treeSet;
        }

        public List<Span> find(String processId) {
            ArrayList<Span> spans = new ArrayList<Span>();
            Span span = new MilliSpan("", Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, processId);
            while ((span = this.treeSet.higher(span)) != null && !span.getProcessId().equals(processId)) {
                spans.add(span);
            }
            return spans;
        }

        public Iterator<Span> iterator() {
            return Collections.unmodifiableSortedSet(this.treeSet).iterator();
        }
    }

    public static class SpansByParent {
        private static Comparator<Span> COMPARATOR = new Comparator<Span>(){

            @Override
            public int compare(Span a, Span b) {
                if (a.getParentId() < b.getParentId()) {
                    return -1;
                }
                if (a.getParentId() > b.getParentId()) {
                    return 1;
                }
                if (a.getSpanId() < b.getSpanId()) {
                    return -1;
                }
                if (a.getSpanId() > b.getSpanId()) {
                    return 1;
                }
                return 0;
            }
        };
        private final TreeSet<Span> treeSet;

        SpansByParent(Collection<Span> spans) {
            TreeSet<Span> treeSet = new TreeSet<Span>(COMPARATOR);
            for (Span span : spans) {
                treeSet.add(span);
            }
            this.treeSet = treeSet;
        }

        public List<Span> find(long parentId) {
            ArrayList<Span> spans = new ArrayList<Span>();
            Span span = new MilliSpan("", Long.MIN_VALUE, parentId, Long.MIN_VALUE, "");
            while ((span = this.treeSet.higher(span)) != null && span.getParentId() == parentId) {
                spans.add(span);
            }
            return spans;
        }

        public Iterator<Span> iterator() {
            return Collections.unmodifiableSortedSet(this.treeSet).iterator();
        }
    }
}

