/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import org.apache.flink.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.flink.hbase.shaded.com.google.protobuf.Message;
import org.apache.flink.hbase.shaded.com.google.protobuf.MessageLite;
import org.apache.flink.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HConstants;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
public class MasterCoprocessorRpcChannel
extends CoprocessorRpcChannel {
    private static final Log LOG = LogFactory.getLog(MasterCoprocessorRpcChannel.class);
    private final ClusterConnection connection;

    public MasterCoprocessorRpcChannel(ClusterConnection conn) {
        this.connection = conn;
    }

    @Override
    protected Message callExecService(RpcController controller, Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Call: " + method.getName() + ", " + request.toString());
        }
        ClientProtos.CoprocessorServiceCall call = CoprocessorRpcUtils.buildServiceCall(HConstants.EMPTY_BYTE_ARRAY, method, request);
        ClientProtos.CoprocessorServiceResponse result = ProtobufUtil.execService(controller, this.connection.getMaster(), call);
        MessageLite response = null;
        if (result.getValue().hasValue()) {
            Message.Builder builder = responsePrototype.newBuilderForType();
            ProtobufUtil.mergeFrom(builder, result.getValue().getValue());
            response = builder.build();
        } else {
            response = responsePrototype.getDefaultInstanceForType();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Master Result is value=" + response);
        }
        return response;
    }
}

