/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.Cell;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter.Filter;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FamilyFilter
extends CompareFilter {
    public FamilyFilter(CompareFilter.CompareOp familyCompareOp, ByteArrayComparable familyComparator) {
        super(familyCompareOp, familyComparator);
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        byte familyLength = v.getFamilyLength();
        if (familyLength > 0 && this.doCompare(this.compareOp, this.comparator, v.getFamilyArray(), v.getFamilyOffset(), familyLength)) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Object> arguments = CompareFilter.extractArguments(filterArguments);
        CompareFilter.CompareOp compareOp = (CompareFilter.CompareOp)((Object)arguments.get(0));
        ByteArrayComparable comparator = (ByteArrayComparable)arguments.get(1);
        return new FamilyFilter(compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FamilyFilter.Builder builder = FilterProtos.FamilyFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static FamilyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FamilyFilter proto;
        try {
            proto = FilterProtos.FamilyFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        CompareFilter.CompareOp valueCompareOp = CompareFilter.CompareOp.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new FamilyFilter(valueCompareOp, valueComparator);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FamilyFilter)) {
            return false;
        }
        FamilyFilter other = (FamilyFilter)o;
        return super.areSerializedFieldsEqual(other);
    }
}

