/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.Log;
import org.apache.flink.hbase.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.HTable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Mutation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Put;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Row;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RowAccess;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BufferedMutatorImpl
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(BufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    protected ClusterConnection connection;
    private final TableName tableName;
    private volatile Configuration conf;
    @VisibleForTesting
    final ConcurrentLinkedQueue<Mutation> writeAsyncBuffer = new ConcurrentLinkedQueue();
    @VisibleForTesting
    AtomicLong currentWriteBufferSize = new AtomicLong(0L);
    @VisibleForTesting
    AtomicInteger undealtMutationCount = new AtomicInteger(0);
    private long writeBufferSize;
    private final int maxKeyValueSize;
    private boolean closed = false;
    private final ExecutorService pool;
    private int writeRpcTimeout;
    private int operationTimeout;
    @VisibleForTesting
    protected AsyncProcess ap;

    BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        this.connection = conn;
        this.conf = this.connection.getConfiguration();
        this.pool = params.getPool();
        this.listener = params.getListener();
        ConnectionConfiguration tableConf = new ConnectionConfiguration(this.conf);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : tableConf.getWriteBufferSize();
        this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : tableConf.getMaxKeyValueSize();
        this.writeRpcTimeout = conn.getConfiguration().getInt("hbase.rpc.write.timeout", conn.getConfiguration().getInt("hbase.rpc.timeout", 60000));
        this.operationTimeout = conn.getConfiguration().getInt("hbase.client.operation.timeout", 1200000);
        this.ap = new AsyncProcess(this.connection, this.conf, this.pool, rpcCallerFactory, true, rpcFactory, this.writeRpcTimeout);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void mutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.mutate(Arrays.asList(m));
    }

    @Override
    public void mutate(List<? extends Mutation> ms) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.closed) {
            throw new IllegalStateException("Cannot put when the BufferedMutator is closed.");
        }
        long toAddSize = 0L;
        int toAddCount = 0;
        for (Mutation mutation : ms) {
            if (mutation instanceof Put) {
                this.validatePut((Put)mutation);
            }
            toAddSize += mutation.heapSize();
            ++toAddCount;
        }
        if (this.ap.hasError()) {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.undealtMutationCount.addAndGet(toAddCount);
            this.backgroundFlushCommits(true);
        } else {
            this.currentWriteBufferSize.addAndGet(toAddSize);
            this.writeAsyncBuffer.addAll(ms);
            this.undealtMutationCount.addAndGet(toAddCount);
        }
        while (this.undealtMutationCount.get() != 0 && this.currentWriteBufferSize.get() > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.maxKeyValueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            boolean terminated;
            if (this.closed) {
                return;
            }
            this.backgroundFlushCommits(true);
            this.pool.shutdown();
            int loopCnt = 0;
            do {
                terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS);
                if (++loopCnt < 10) continue;
                LOG.warn("close() failed to terminate pool after 10 minutes. Abandoning pool.");
                break;
            } while (!terminated);
        }
        catch (InterruptedException e) {
            LOG.warn("waitForTermination interrupted");
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        Throwable throwable;
        QueueRowAccess taker;
        if (!synchronous && this.writeAsyncBuffer.isEmpty()) {
            return;
        }
        if (!synchronous) {
            taker = this.createQueueRowAccess();
            throwable = null;
            try {
                this.ap.submit(this.tableName, taker, true, null, false);
                if (this.ap.hasError()) {
                    LOG.debug(this.tableName + ": One or more of the operations have failed -" + " waiting for all operation in progress to finish (successfully or not)");
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (taker != null) {
                    if (throwable != null) {
                        try {
                            taker.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        taker.close();
                    }
                }
            }
        }
        if (synchronous || this.ap.hasError()) {
            while (true) {
                taker = this.createQueueRowAccess();
                throwable = null;
                try {
                    if (taker.isEmpty()) break;
                    this.ap.submit(this.tableName, taker, true, null, false);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (taker == null) continue;
                    if (throwable != null) {
                        try {
                            taker.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    taker.close();
                    continue;
                }
                break;
            }
            RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(null, this.tableName.getNameAsString());
            if (error != null) {
                if (this.listener == null) {
                    throw error;
                }
                this.listener.onException(error, this);
            }
        }
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws RetriesExhaustedWithDetailsException, InterruptedIOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize.get() > writeBufferSize) {
            this.flush();
        }
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setRpcTimeout(int writeRpcTimeout) {
        this.writeRpcTimeout = writeRpcTimeout;
        this.ap.setRpcTimeout(writeRpcTimeout);
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        this.ap.setOperationTimeout(operationTimeout);
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        return Arrays.asList(this.writeAsyncBuffer.toArray(new Row[0]));
    }

    @VisibleForTesting
    QueueRowAccess createQueueRowAccess() {
        return new QueueRowAccess();
    }

    @VisibleForTesting
    class QueueRowAccess
    implements RowAccess<Row>,
    Closeable {
        private int remainder;
        private Mutation last;

        QueueRowAccess() {
            this.remainder = BufferedMutatorImpl.this.undealtMutationCount.getAndSet(0);
            this.last = null;
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                private int countDown;
                {
                    this.countDown = QueueRowAccess.this.remainder;
                }

                @Override
                public boolean hasNext() {
                    return this.countDown > 0;
                }

                @Override
                public Row next() {
                    QueueRowAccess.this.restoreLastMutation();
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    QueueRowAccess.this.last = BufferedMutatorImpl.this.writeAsyncBuffer.poll();
                    if (QueueRowAccess.this.last == null) {
                        throw new NoSuchElementException();
                    }
                    BufferedMutatorImpl.this.currentWriteBufferSize.addAndGet(-QueueRowAccess.this.last.heapSize());
                    --this.countDown;
                    return QueueRowAccess.this.last;
                }

                @Override
                public void remove() {
                    if (QueueRowAccess.this.last == null) {
                        throw new IllegalStateException();
                    }
                    --QueueRowAccess.this.remainder;
                    QueueRowAccess.this.last = null;
                }
            };
        }

        private void restoreLastMutation() {
            if (this.last != null) {
                BufferedMutatorImpl.this.writeAsyncBuffer.add(this.last);
                BufferedMutatorImpl.this.currentWriteBufferSize.addAndGet(this.last.heapSize());
                this.last = null;
            }
        }

        @Override
        public int size() {
            return this.remainder;
        }

        @Override
        public boolean isEmpty() {
            return this.remainder <= 0;
        }

        @Override
        public void close() {
            this.restoreLastMutation();
            if (this.remainder > 0) {
                BufferedMutatorImpl.this.undealtMutationCount.addAndGet(this.remainder);
                this.remainder = 0;
            }
        }
    }
}

