/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.table;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.table.factories.FactoryUtil;

@PublicEvolving
public class HBaseConnectorOptions {
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("The name of HBase table to connect. By default, the table is in 'default' namespace. To assign the table a specified namespace you need to use 'namespace:table'.");
    public static final ConfigOption<String> ZOOKEEPER_QUORUM = ConfigOptions.key((String)"zookeeper.quorum").stringType().noDefaultValue().withDescription("The HBase Zookeeper quorum.");
    public static final ConfigOption<String> ZOOKEEPER_ZNODE_PARENT = ConfigOptions.key((String)"zookeeper.znode.parent").stringType().defaultValue((Object)"/hbase").withDescription("The root dir in Zookeeper for HBase cluster.");
    public static final ConfigOption<String> NULL_STRING_LITERAL = ConfigOptions.key((String)"null-string-literal").stringType().defaultValue((Object)"null").withDescription("Representation for null values for string fields. HBase source and sink encodes/decodes empty bytes as null values for all types except string type.");
    public static final ConfigOption<MemorySize> SINK_BUFFER_FLUSH_MAX_SIZE = ConfigOptions.key((String)"sink.buffer-flush.max-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("Writing option, maximum size in memory of buffered rows for each writing request. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it. ");
    public static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").intType().defaultValue((Object)1000).withDescription("Writing option, maximum number of rows to buffer for each writing request. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it.");
    public static final ConfigOption<Duration> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Writing option, the interval to flush any buffered rows. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it. Note, both 'sink.buffer-flush.max-size' and 'sink.buffer-flush.max-rows' can be set to '0' with the flush interval set allowing for complete async processing of buffered actions.");
    public static final ConfigOption<Boolean> LOOKUP_ASYNC = ConfigOptions.key((String)"lookup.async").booleanType().defaultValue((Object)false).withDescription("whether to set async lookup.");
    @Deprecated
    public static final ConfigOption<Long> LOOKUP_CACHE_MAX_ROWS = ConfigOptions.key((String)"lookup.cache.max-rows").longType().defaultValue((Object)-1L).withDescription("the max number of rows of lookup cache, over this value, the oldest rows will be eliminated. \"cache.max-rows\" and \"cache.ttl\" options must all be specified if any of them is specified. Cache is not enabled as default.");
    @Deprecated
    public static final ConfigOption<Duration> LOOKUP_CACHE_TTL = ConfigOptions.key((String)"lookup.cache.ttl").durationType().defaultValue((Object)Duration.ofSeconds(0L)).withDescription("the cache time to live.");
    public static final ConfigOption<Integer> LOOKUP_MAX_RETRIES = ConfigOptions.key((String)"lookup.max-retries").intType().defaultValue((Object)3).withDescription("the max retry times if lookup database failed.");
    public static final ConfigOption<Integer> SINK_PARALLELISM = FactoryUtil.SINK_PARALLELISM;

    private HBaseConnectorOptions() {
    }
}

