/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.source.HBaseRowDataLookupFunction;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.lookup.LookupFunctionProvider;
import org.apache.flink.table.connector.source.lookup.PartialCachingLookupProvider;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.LookupFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public abstract class AbstractHBaseDynamicTableSource
implements ScanTableSource,
LookupTableSource,
SupportsProjectionPushDown {
    protected final Configuration conf;
    protected final String tableName;
    protected HBaseTableSchema hbaseSchema;
    protected final String nullStringLiteral;
    protected final int maxRetryTimes;
    @Nullable
    protected final LookupCache cache;

    public AbstractHBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral, int maxRetryTimes, @Nullable LookupCache cache) {
        this.conf = conf;
        this.tableName = tableName;
        this.hbaseSchema = hbaseSchema;
        this.nullStringLiteral = nullStringLiteral;
        this.maxRetryTimes = maxRetryTimes;
        this.cache = cache;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        return InputFormatProvider.of(this.getInputFormat());
    }

    protected abstract InputFormat<RowData, ?> getInputFormat();

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        Preconditions.checkArgument((context.getKeys().length == 1 && context.getKeys()[0].length == 1 ? 1 : 0) != 0, (Object)"Currently, HBase table can only be lookup by single rowkey.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.getRowKeyName().isPresent(), (Object)"HBase schema must have a row key when used in lookup mode.");
        Preconditions.checkArgument((boolean)((String)DataType.getFieldNames((DataType)this.hbaseSchema.convertToDataType()).get(context.getKeys()[0][0])).equals(this.hbaseSchema.getRowKeyName().get()), (Object)"Currently, HBase table only supports lookup by rowkey field.");
        HBaseRowDataLookupFunction lookupFunction = new HBaseRowDataLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes);
        if (this.cache != null) {
            return PartialCachingLookupProvider.of((LookupFunction)lookupFunction, (LookupCache)this.cache);
        }
        return LookupFunctionProvider.of((LookupFunction)lookupFunction);
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.hbaseSchema = HBaseTableSchema.fromDataType(Projection.of((int[][])projectedFields).project(this.hbaseSchema.convertToDataType()));
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public String asSummaryString() {
        return "HBase";
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseSchema;
    }

    @VisibleForTesting
    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    @Nullable
    @VisibleForTesting
    public LookupCache getCache() {
        return this.cache;
    }
}

