/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.quotas.ThrottleType;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ThrottleSettings
extends QuotaSettings {
    private final QuotaProtos.ThrottleRequest proto;

    ThrottleSettings(String userName, TableName tableName, String namespace, QuotaProtos.ThrottleRequest proto) {
        super(userName, tableName, namespace);
        this.proto = proto;
    }

    public ThrottleType getThrottleType() {
        return ProtobufUtil.toThrottleType(this.proto.getType());
    }

    public long getSoftLimit() {
        return this.proto.hasTimedQuota() ? this.proto.getTimedQuota().getSoftLimit() : -1L;
    }

    public TimeUnit getTimeUnit() {
        return this.proto.hasTimedQuota() ? ProtobufUtil.toTimeUnit(this.proto.getTimedQuota().getTimeUnit()) : null;
    }

    @Override
    public QuotaType getQuotaType() {
        return QuotaType.THROTTLE;
    }

    @Override
    protected void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder builder) {
        builder.setThrottle(this.proto);
    }

    public String toString() {
        StringBuilder builder;
        block10: {
            block7: {
                QuotaProtos.TimedQuota timedQuota;
                block9: {
                    block8: {
                        builder = new StringBuilder();
                        builder.append("TYPE => THROTTLE");
                        if (this.proto.hasType()) {
                            builder.append(", THROTTLE_TYPE => ");
                            builder.append(this.proto.getType().toString());
                        }
                        if (!this.proto.hasTimedQuota()) break block7;
                        timedQuota = this.proto.getTimedQuota();
                        builder.append(", LIMIT => ");
                        if (!timedQuota.hasSoftLimit()) break block8;
                        switch (this.getThrottleType()) {
                            case REQUEST_NUMBER: 
                            case WRITE_NUMBER: 
                            case READ_NUMBER: {
                                builder.append(String.format("%dreq", timedQuota.getSoftLimit()));
                                break block9;
                            }
                            case REQUEST_SIZE: 
                            case WRITE_SIZE: 
                            case READ_SIZE: {
                                builder.append(ThrottleSettings.sizeToString(timedQuota.getSoftLimit()));
                                break block9;
                            }
                            default: {
                                throw new RuntimeException("Invalid throttle type: " + (Object)((Object)this.getThrottleType()));
                            }
                        }
                    }
                    if (timedQuota.hasShare()) {
                        builder.append(String.format("%.2f%%", Float.valueOf(timedQuota.getShare())));
                    }
                }
                builder.append('/');
                builder.append(ThrottleSettings.timeToString(ProtobufUtil.toTimeUnit(timedQuota.getTimeUnit())));
                if (timedQuota.hasScope()) {
                    builder.append(", SCOPE => ");
                    builder.append(timedQuota.getScope().toString());
                }
                break block10;
            }
            builder.append(", LIMIT => NONE");
        }
        return builder.toString();
    }

    static ThrottleSettings fromTimedQuota(String userName, TableName tableName, String namespace, ThrottleType type, QuotaProtos.TimedQuota timedQuota) {
        QuotaProtos.ThrottleRequest.Builder builder = QuotaProtos.ThrottleRequest.newBuilder();
        builder.setType(ProtobufUtil.toProtoThrottleType(type));
        builder.setTimedQuota(timedQuota);
        return new ThrottleSettings(userName, tableName, namespace, builder.build());
    }
}

