/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Attributes;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Operation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class OperationWithAttributes
extends Operation
implements Attributes {
    private Map<String, byte[]> attributes;
    public static final String ID_ATRIBUTE = "_operation.attributes.id";
    private int priority = -1;

    @Override
    public OperationWithAttributes setAttribute(String name, byte[] value) {
        if (this.attributes == null && value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, byte[]>();
        }
        if (value == null) {
            this.attributes.remove(name);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    @Override
    public byte[] getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Map<String, byte[]> getAttributesMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    protected long getAttributeSize() {
        long size = 0L;
        if (this.attributes != null) {
            size += (long)ClassSize.align(this.attributes.size() * ClassSize.MAP_ENTRY);
            for (Map.Entry<String, byte[]> entry : this.attributes.entrySet()) {
                size += (long)ClassSize.align(ClassSize.STRING + entry.getKey().length());
                size += (long)ClassSize.align(ClassSize.ARRAY + entry.getValue().length);
            }
        }
        return size;
    }

    public OperationWithAttributes setId(String id) {
        this.setAttribute(ID_ATRIBUTE, Bytes.toBytes(id));
        return this;
    }

    public String getId() {
        byte[] attr = this.getAttribute(ID_ATRIBUTE);
        return attr == null ? null : Bytes.toString(attr);
    }

    public OperationWithAttributes setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }
}

