/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase1.source;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.source.AbstractHBaseDynamicTableSource;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase1.source.HBaseRowDataInputFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseDynamicTableSource
extends AbstractHBaseDynamicTableSource {
    public HBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral, int maxRetryTimes, @Nullable LookupCache cache) {
        super(conf, tableName, hbaseSchema, nullStringLiteral, maxRetryTimes, cache);
    }

    public DynamicTableSource copy() {
        return new HBaseDynamicTableSource(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes, this.cache);
    }

    @Override
    public InputFormat<RowData, ?> getInputFormat() {
        return new HBaseRowDataInputFormat(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HBaseDynamicTableSource)) {
            return false;
        }
        HBaseDynamicTableSource that = (HBaseDynamicTableSource)o;
        return Objects.equals(this.conf, that.conf) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.hbaseSchema, that.hbaseSchema) && Objects.equals(this.nullStringLiteral, that.nullStringLiteral) && Objects.equals(this.maxRetryTimes, that.maxRetryTimes) && Objects.equals(this.cache, that.cache);
    }

    public int hashCode() {
        return Objects.hash(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.maxRetryTimes, this.cache);
    }
}

