/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter;

import org.apache.flink.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class LongComparator
extends ByteArrayComparable {
    private long longValue;

    public LongComparator(long value) {
        super(Bytes.toBytes(value));
        this.longValue = value;
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        long that = Bytes.toLong(value, offset, length);
        return Long.compare(this.longValue, that);
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.LongComparator.Builder builder = ComparatorProtos.LongComparator.newBuilder();
        builder.setComparable(super.convert());
        return builder.build().toByteArray();
    }

    public static LongComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.LongComparator proto;
        try {
            proto = ComparatorProtos.LongComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new LongComparator(Bytes.toLong(proto.getComparable().getValue().toByteArray()));
    }

    boolean areSerializedFieldsEqual(LongComparator other) {
        if (other == this) {
            return true;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

