/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase1;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptions;
import org.apache.flink.connector.hbase.table.HBaseConnectorOptionsUtil;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.connector.hbase1.sink.HBaseDynamicTableSink;
import org.apache.flink.connector.hbase1.source.HBaseDynamicTableSource;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBase1DynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final String IDENTIFIER = "hbase-1.4";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        HBaseConnectorOptionsUtil.validatePrimaryKey(context.getPhysicalRowDataType(), context.getPrimaryKeyIndexes());
        String tableName = (String)tableOptions.get(HBaseConnectorOptions.TABLE_NAME);
        Configuration hbaseClientConf = HBaseConnectorOptionsUtil.getHBaseConfiguration(tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseConnectorOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromDataType(context.getPhysicalRowDataType());
        return new HBaseDynamicTableSource(hbaseClientConf, tableName, hbaseSchema, nullStringLiteral, HBaseConnectorOptionsUtil.getHBaseLookupOptions(tableOptions));
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"properties."});
        ReadableConfig tableOptions = helper.getOptions();
        HBaseConnectorOptionsUtil.validatePrimaryKey(context.getPhysicalRowDataType(), context.getPrimaryKeyIndexes());
        String tableName = (String)tableOptions.get(HBaseConnectorOptions.TABLE_NAME);
        Configuration hbaseConf = HBaseConnectorOptionsUtil.getHBaseConfiguration(tableOptions);
        HBaseWriteOptions hBaseWriteOptions = HBaseConnectorOptionsUtil.getHBaseWriteOptions(tableOptions);
        String nullStringLiteral = (String)tableOptions.get(HBaseConnectorOptions.NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromDataType(context.getPhysicalRowDataType());
        return new HBaseDynamicTableSink(tableName, hbaseSchema, hbaseConf, hBaseWriteOptions, nullStringLiteral);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(HBaseConnectorOptions.TABLE_NAME);
        set.add(HBaseConnectorOptions.ZOOKEEPER_QUORUM);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(HBaseConnectorOptions.ZOOKEEPER_ZNODE_PARENT);
        set.add(HBaseConnectorOptions.NULL_STRING_LITERAL);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_SIZE);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        set.add(HBaseConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        set.add(HBaseConnectorOptions.SINK_PARALLELISM);
        set.add(HBaseConnectorOptions.LOOKUP_ASYNC);
        set.add(HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS);
        set.add(HBaseConnectorOptions.LOOKUP_CACHE_TTL);
        set.add(HBaseConnectorOptions.LOOKUP_MAX_RETRIES);
        return set;
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.of(HBaseConnectorOptions.TABLE_NAME, HBaseConnectorOptions.ZOOKEEPER_ZNODE_PARENT, HBaseConnectorOptions.ZOOKEEPER_QUORUM, HBaseConnectorOptions.NULL_STRING_LITERAL, HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_SIZE, HBaseConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS, HBaseConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL, HBaseConnectorOptions.LOOKUP_CACHE_MAX_ROWS, HBaseConnectorOptions.LOOKUP_CACHE_TTL, HBaseConnectorOptions.LOOKUP_MAX_RETRIES).collect(Collectors.toSet());
    }
}

