/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.options.HBaseLookupOptions;
import org.apache.flink.connector.hbase.source.HBaseRowDataLookupFunction;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public abstract class AbstractHBaseDynamicTableSource
implements ScanTableSource,
LookupTableSource,
SupportsProjectionPushDown {
    protected final Configuration conf;
    protected final String tableName;
    protected HBaseTableSchema hbaseSchema;
    protected final String nullStringLiteral;
    protected final HBaseLookupOptions lookupOptions;

    public AbstractHBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral, HBaseLookupOptions lookupOptions) {
        this.conf = conf;
        this.tableName = tableName;
        this.hbaseSchema = hbaseSchema;
        this.nullStringLiteral = nullStringLiteral;
        this.lookupOptions = lookupOptions;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        return InputFormatProvider.of(this.getInputFormat());
    }

    protected abstract InputFormat<RowData, ?> getInputFormat();

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        Preconditions.checkArgument((context.getKeys().length == 1 && context.getKeys()[0].length == 1 ? 1 : 0) != 0, (Object)"Currently, HBase table can only be lookup by single rowkey.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.getRowKeyName().isPresent(), (Object)"HBase schema must have a row key when used in lookup mode.");
        Preconditions.checkArgument((boolean)((String)DataType.getFieldNames((DataType)this.hbaseSchema.convertToDataType()).get(context.getKeys()[0][0])).equals(this.hbaseSchema.getRowKeyName().get()), (Object)"Currently, HBase table only supports lookup by rowkey field.");
        return TableFunctionProvider.of((TableFunction)new HBaseRowDataLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral, this.lookupOptions));
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.hbaseSchema = HBaseTableSchema.fromDataType(Projection.of((int[][])projectedFields).project(this.hbaseSchema.convertToDataType()));
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public String asSummaryString() {
        return "HBase";
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseSchema;
    }
}

