/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

public class BytesTransportRequest
extends TransportRequest {
    BytesReference bytes;
    Version version;

    public BytesTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.bytes = in.readBytesReference();
        this.version = in.getVersion();
    }

    public BytesTransportRequest(BytesReference bytes, Version version) {
        this.bytes = bytes;
        this.version = version;
    }

    public Version version() {
        return this.version;
    }

    public BytesReference bytes() {
        return this.bytes;
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.bytes.length());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.bytes);
    }
}

