/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SetOnce;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.NamedWriteable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.SortBy;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.suggest.term.TermSuggestion;

public class Suggest
implements Iterable<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>,
Writeable,
ToXContentFragment {
    public static final String NAME = "suggest";
    public static final Comparator<Suggestion.Entry.Option> COMPARATOR = (first, second) -> {
        int cmp = Float.compare(second.getScore(), first.getScore());
        if (cmp != 0) {
            return cmp;
        }
        return first.getText().compareTo(second.getText());
    };
    private List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions;
    private boolean hasScoreDocs;
    private Map<String, Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestMap;

    public Suggest(List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions) {
        suggestions.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.suggestions = suggestions;
        this.hasScoreDocs = this.filter(CompletionSuggestion.class).stream().anyMatch(CompletionSuggestion::hasScoreDocs);
    }

    public Suggest(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_7_0_0)) {
            int size = in.readVInt();
            this.suggestions = new ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>(size);
            for (int i = 0; i < size; ++i) {
                Suggestion suggestion;
                int type = in.readVInt();
                switch (type) {
                    case 1: {
                        suggestion = new TermSuggestion(in);
                        break;
                    }
                    case 4: {
                        suggestion = new CompletionSuggestion(in);
                        break;
                    }
                    case 3: {
                        suggestion = new PhraseSuggestion(in);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown suggestion type with ordinal " + type);
                    }
                }
                this.suggestions.add(suggestion);
            }
        } else {
            int suggestionCount = in.readVInt();
            this.suggestions = new ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>(suggestionCount);
            for (int i = 0; i < suggestionCount; ++i) {
                this.suggestions.add(in.readNamedWriteable(Suggestion.class));
            }
        }
        this.hasScoreDocs = this.filter(CompletionSuggestion.class).stream().anyMatch(CompletionSuggestion::hasScoreDocs);
    }

    @Override
    public Iterator<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> iterator() {
        return this.suggestions.iterator();
    }

    public int size() {
        return this.suggestions.size();
    }

    public <T extends Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> T getSuggestion(String name) {
        if (this.suggestions.isEmpty() || name == null) {
            return null;
        }
        if (this.suggestions.size() == 1) {
            return (T)(name.equals(this.suggestions.get((int)0).name) ? this.suggestions.get(0) : null);
        }
        if (this.suggestMap == null) {
            this.suggestMap = new HashMap<String, Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>();
            for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> item : this.suggestions) {
                this.suggestMap.put(item.getName(), item);
            }
        }
        return (T)this.suggestMap.get(name);
    }

    public boolean hasScoreDocs() {
        return this.hasScoreDocs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeVInt(this.suggestions.size());
            for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> command : this.suggestions) {
                out.writeVInt(command.getWriteableType());
                command.writeTo(out);
            }
        } else {
            out.writeVInt(this.suggestions.size());
            for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> suggestion : this.suggestions) {
                out.writeNamedWriteable(suggestion);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        for (Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>> suggestion : this.suggestions) {
            suggestion.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static Suggest fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            String currentField = parser.currentName();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.nextToken(), parser::getTokenLocation);
            Suggestion<Suggestion.Entry<Suggestion.Entry.Option>> suggestion = Suggestion.fromXContent(parser);
            if (suggestion != null) {
                suggestions.add(suggestion);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Could not parse suggestion keyed as [%s]", currentField), new Object[0]);
        }
        return new Suggest(suggestions);
    }

    public static List<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> reduce(Map<String, List<Suggestion>> groupedSuggestions) {
        ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>> reduced = new ArrayList<Suggestion<? extends Suggestion.Entry<? extends Suggestion.Entry.Option>>>(groupedSuggestions.size());
        for (Map.Entry<String, List<Suggestion>> unmergedResults : groupedSuggestions.entrySet()) {
            List value = unmergedResults.getValue();
            Class<?> suggestionClass = null;
            for (Suggestion suggestion : value) {
                if (suggestionClass == null) {
                    suggestionClass = suggestion.getClass();
                    continue;
                }
                if (suggestionClass == suggestion.getClass()) continue;
                throw new IllegalArgumentException("detected mixed suggestion results, due to querying on old and new completion suggester, query on a single completion suggester version");
            }
            Suggestion reduce = value.get(0).reduce(value);
            reduce.trim();
            reduced.add(reduce);
        }
        return reduced;
    }

    public <T extends Suggestion> List<T> filter(Class<T> suggestionType) {
        return this.suggestions.stream().filter((? super T suggestion) -> suggestion.getClass() == suggestionType).map(suggestion -> suggestion).collect(Collectors.toList());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals(this.suggestions, ((Suggest)other).suggestions);
    }

    public int hashCode() {
        return Objects.hash(this.suggestions);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static abstract class Suggestion<T extends Entry>
    implements Iterable<T>,
    NamedWriteable,
    ToXContentFragment {
        public static final int TYPE = 0;
        protected final String name;
        protected final int size;
        protected final List<T> entries = new ArrayList<T>(5);

        public Suggestion(String name, int size) {
            this.name = name;
            this.size = size;
        }

        public Suggestion(StreamInput in) throws IOException {
            this.name = in.readString();
            this.size = in.readVInt();
            if (in.getVersion().before(Version.V_7_0_0) && this instanceof TermSuggestion) {
                TermSuggestion t = (TermSuggestion)this;
                t.setSort(SortBy.readFromStream(in));
            }
            int entriesCount = in.readVInt();
            this.entries.clear();
            for (int i = 0; i < entriesCount; ++i) {
                T newEntry = this.newEntry(in);
                this.entries.add(newEntry);
            }
        }

        public void addTerm(T entry) {
            this.entries.add(entry);
        }

        @Deprecated
        public int getWriteableType() {
            return 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this.entries.iterator();
        }

        public List<T> getEntries() {
            return this.entries;
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        public Suggestion<T> reduce(List<Suggestion<T>> toReduce) {
            if (toReduce.size() == 1) {
                return toReduce.get(0);
            }
            if (toReduce.isEmpty()) {
                return null;
            }
            Suggestion<T> leader = toReduce.get(0);
            List<T> entries = leader.entries;
            int size = entries.size();
            Comparator<Entry.Option> sortComparator = this.sortComparator();
            ArrayList<Entry> currentEntries = new ArrayList<Entry>();
            for (int i = 0; i < size; ++i) {
                for (Suggestion<T> suggestion : toReduce) {
                    if (suggestion.entries.size() != size) {
                        throw new IllegalStateException("Can't merge suggest result, this might be caused by suggest calls across multiple indices with different analysis chains. Suggest entries have different sizes actual [" + suggestion.entries.size() + "] expected [" + size + "]");
                    }
                    assert (suggestion.name.equals(leader.name));
                    currentEntries.add((Entry)suggestion.entries.get(i));
                }
                Entry<Entry.Option> entry = ((Entry)entries.get(i)).reduce(currentEntries);
                entry.sort(sortComparator);
                entries.set(i, entry);
                currentEntries.clear();
            }
            return leader;
        }

        protected Comparator<Entry.Option> sortComparator() {
            return COMPARATOR;
        }

        public void trim() {
            for (Entry entry : this.entries) {
                entry.trim(this.size);
            }
        }

        protected abstract T newEntry(StreamInput var1) throws IOException;

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVInt(this.size);
            if (out.getVersion().before(Version.V_7_0_0) && this instanceof TermSuggestion) {
                TermSuggestion termSuggestion = (TermSuggestion)this;
                termSuggestion.getSort().writeTo(out);
            }
            out.writeVInt(this.entries.size());
            for (Entry entry : this.entries) {
                entry.writeTo(out);
            }
        }

        @Override
        public abstract String getWriteableName();

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (params.paramAsBoolean("typed_keys", false)) {
                builder.startArray(String.join((CharSequence)"#", this.getWriteableName(), this.getName()));
            } else {
                builder.startArray(this.getName());
            }
            for (Entry entry : this.entries) {
                builder.startObject();
                entry.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Suggestion otherSuggestion = (Suggestion)other;
            return Objects.equals(this.name, otherSuggestion.name) && Objects.equals(this.size, otherSuggestion.size) && Objects.equals(this.entries, otherSuggestion.entries);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.size, this.entries);
        }

        public static Suggestion<? extends Entry<? extends Entry.Option>> fromXContent(XContentParser parser) throws IOException {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser::getTokenLocation);
            SetOnce suggestion = new SetOnce();
            XContentParserUtils.parseTypedKeysObject(parser, "#", Suggestion.class, suggestion::set);
            return (Suggestion)suggestion.get();
        }

        protected static <E extends Entry<?>> void parseEntries(XContentParser parser, Suggestion<E> suggestion, CheckedFunction<XContentParser, E, IOException> entryParser) throws IOException {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser::getTokenLocation);
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                suggestion.addTerm((Entry)entryParser.apply(parser));
            }
        }

        public static abstract class Entry<O extends Option>
        implements Iterable<O>,
        Writeable,
        ToXContentFragment {
            private static final String TEXT = "text";
            private static final String OFFSET = "offset";
            private static final String LENGTH = "length";
            protected static final String OPTIONS = "options";
            protected Text text;
            protected int offset;
            protected int length;
            protected List<O> options = new ArrayList<O>(5);

            public Entry(Text text, int offset, int length) {
                this.text = text;
                this.offset = offset;
                this.length = length;
            }

            protected Entry() {
            }

            public Entry(StreamInput in) throws IOException {
                this.text = in.readText();
                this.offset = in.readVInt();
                this.length = in.readVInt();
                int suggestedWords = in.readVInt();
                this.options = new ArrayList<O>(suggestedWords);
                for (int j = 0; j < suggestedWords; ++j) {
                    O newOption = this.newOption(in);
                    this.options.add(newOption);
                }
            }

            public void addOption(O option) {
                this.options.add(option);
            }

            protected void addOptions(List<O> options) {
                for (Option option : options) {
                    this.addOption(option);
                }
            }

            protected void sort(Comparator<O> comparator) {
                CollectionUtil.timSort(this.options, comparator);
            }

            protected <T extends Entry<O>> Entry<O> reduce(List<T> toReduce) {
                if (toReduce.size() == 1) {
                    return (Entry)toReduce.get(0);
                }
                HashMap<Option, Option> entries = new HashMap<Option, Option>();
                Entry leader = (Entry)toReduce.get(0);
                for (Entry entry : toReduce) {
                    if (!leader.text.equals(entry.text)) {
                        throw new IllegalStateException("Can't merge suggest entries, this might be caused by suggest calls across multiple indices with different analysis chains. Suggest entries have different text actual [" + entry.text + "] expected [" + leader.text + "]");
                    }
                    assert (leader.offset == entry.offset);
                    assert (leader.length == entry.length);
                    leader.merge(entry);
                    for (Option option : entry) {
                        Option merger = (Option)entries.get(option);
                        if (merger == null) {
                            entries.put(option, option);
                            continue;
                        }
                        merger.mergeInto(option);
                    }
                }
                leader.options.clear();
                for (Option option : entries.keySet()) {
                    leader.addOption(option);
                }
                return leader;
            }

            protected void merge(Entry<O> other) {
            }

            public Text getText() {
                return this.text;
            }

            public int getOffset() {
                return this.offset;
            }

            public int getLength() {
                return this.length;
            }

            @Override
            public Iterator<O> iterator() {
                return this.options.iterator();
            }

            public List<O> getOptions() {
                return this.options;
            }

            void trim(int size) {
                int optionsToRemove = Math.max(0, this.options.size() - size);
                for (int i = 0; i < optionsToRemove; ++i) {
                    this.options.remove(this.options.size() - 1);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                return Objects.equals(this.length, entry.length) && Objects.equals(this.offset, entry.offset) && Objects.equals(this.text, entry.text) && Objects.equals(this.options, entry.options);
            }

            public int hashCode() {
                return Objects.hash(this.text, this.offset, this.length, this.options);
            }

            protected abstract O newOption(StreamInput var1) throws IOException;

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeText(this.text);
                out.writeVInt(this.offset);
                out.writeVInt(this.length);
                out.writeVInt(this.options.size());
                for (Option option : this.options) {
                    option.writeTo(out);
                }
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field(TEXT, this.text);
                builder.field(OFFSET, this.offset);
                builder.field(LENGTH, this.length);
                builder.startArray(OPTIONS);
                for (Option option : this.options) {
                    builder.startObject();
                    option.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                return builder;
            }

            protected static void declareCommonFields(ObjectParser<? extends Entry<? extends Option>, Void> parser) {
                parser.declareString((entry, text) -> {
                    entry.text = new Text((String)text);
                }, new ParseField(TEXT, new String[0]));
                parser.declareInt((entry, offset) -> {
                    entry.offset = offset;
                }, new ParseField(OFFSET, new String[0]));
                parser.declareInt((entry, length) -> {
                    entry.length = length;
                }, new ParseField(LENGTH, new String[0]));
            }

            public static abstract class Option
            implements Writeable,
            ToXContentFragment {
                public static final ParseField TEXT = new ParseField("text", new String[0]);
                public static final ParseField HIGHLIGHTED = new ParseField("highlighted", new String[0]);
                public static final ParseField SCORE = new ParseField("score", new String[0]);
                public static final ParseField COLLATE_MATCH = new ParseField("collate_match", new String[0]);
                private final Text text;
                private final Text highlighted;
                private float score;
                private Boolean collateMatch;

                public Option(Text text, Text highlighted, float score, Boolean collateMatch) {
                    this.text = text;
                    this.highlighted = highlighted;
                    this.score = score;
                    this.collateMatch = collateMatch;
                }

                public Option(Text text, Text highlighted, float score) {
                    this(text, highlighted, score, null);
                }

                public Option(Text text, float score) {
                    this(text, null, score);
                }

                public Option(StreamInput in) throws IOException {
                    this.text = in.readText();
                    this.score = in.readFloat();
                    this.highlighted = in.readOptionalText();
                    this.collateMatch = in.readOptionalBoolean();
                }

                public Text getText() {
                    return this.text;
                }

                public Text getHighlighted() {
                    return this.highlighted;
                }

                public float getScore() {
                    return this.score;
                }

                public boolean collateMatch() {
                    return this.collateMatch != null ? this.collateMatch : true;
                }

                protected void setScore(float score) {
                    this.score = score;
                }

                @Override
                public void writeTo(StreamOutput out) throws IOException {
                    out.writeText(this.text);
                    out.writeFloat(this.score);
                    out.writeOptionalText(this.highlighted);
                    out.writeOptionalBoolean(this.collateMatch);
                }

                @Override
                public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    builder.field(TEXT.getPreferredName(), this.text);
                    if (this.highlighted != null) {
                        builder.field(HIGHLIGHTED.getPreferredName(), this.highlighted);
                    }
                    builder.field(SCORE.getPreferredName(), this.score);
                    if (this.collateMatch != null) {
                        builder.field(COLLATE_MATCH.getPreferredName(), (boolean)this.collateMatch);
                    }
                    return builder;
                }

                protected void mergeInto(Option otherOption) {
                    this.score = Math.max(this.score, otherOption.score);
                    if (otherOption.collateMatch != null) {
                        this.collateMatch = this.collateMatch == null ? otherOption.collateMatch : Boolean.valueOf(this.collateMatch | otherOption.collateMatch);
                    }
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    Option that = (Option)o;
                    return Objects.equals(this.text, that.text);
                }

                public int hashCode() {
                    return Objects.hash(this.text);
                }
            }
        }
    }
}

