/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AbstractSortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AbstractSortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;

public enum MissingValues {


    public static ValuesSource.Bytes replaceMissing(final ValuesSource.Bytes valuesSource, final BytesRef missing) {
        return new ValuesSource.Bytes(){

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                SortedBinaryDocValues values = valuesSource.bytesValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            public String toString() {
                return "anon ValuesSource.Bytes of [" + super.toString() + "]";
            }
        };
    }

    static SortedBinaryDocValues replaceMissing(final SortedBinaryDocValues values, final BytesRef missing) {
        return new SortedBinaryDocValues(){
            private int count;

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.count = values.advanceExact(doc) ? values.docValueCount() : 0;
                return true;
            }

            @Override
            public int docValueCount() {
                return this.count == 0 ? 1 : this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                if (this.count > 0) {
                    return values.nextValue();
                }
                return missing;
            }

            public String toString() {
                return "anon SortedBinaryDocValues of [" + super.toString() + "]";
            }
        };
    }

    public static ValuesSource.Numeric replaceMissing(final ValuesSource.Numeric valuesSource, final Number missing) {
        boolean missingIsFloat = missing.doubleValue() % 1.0 != 0.0;
        final boolean isFloatingPoint = valuesSource.isFloatingPoint() || missingIsFloat;
        return new ValuesSource.Numeric(){

            @Override
            public boolean isFloatingPoint() {
                return isFloatingPoint;
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing(valuesSource.bytesValues(context), new BytesRef(missing.toString()));
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
                SortedNumericDocValues values = valuesSource.longValues(context);
                return MissingValues.replaceMissing(values, missing.longValue());
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                SortedNumericDoubleValues values = valuesSource.doubleValues(context);
                return MissingValues.replaceMissing(values, missing.doubleValue());
            }

            public String toString() {
                return "anon ValuesSource.Numeric of [" + super.toString() + "]";
            }
        };
    }

    static SortedNumericDocValues replaceMissing(final SortedNumericDocValues values, final long missing) {
        return new AbstractSortedNumericDocValues(){
            private int count;

            @Override
            public long nextValue() throws IOException {
                if (this.count > 0) {
                    return values.nextValue();
                }
                return missing;
            }

            @Override
            public int docValueCount() {
                return this.count == 0 ? 1 : this.count;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.count = values.advanceExact(doc) ? values.docValueCount() : 0;
                return true;
            }

            public String toString() {
                return "anon SortedNumericDocValues of [" + super.toString() + "]";
            }
        };
    }

    static SortedNumericDoubleValues replaceMissing(final SortedNumericDoubleValues values, final double missing) {
        return new SortedNumericDoubleValues(){
            private int count;

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.count = values.advanceExact(doc) ? values.docValueCount() : 0;
                return true;
            }

            @Override
            public double nextValue() throws IOException {
                if (this.count > 0) {
                    return values.nextValue();
                }
                return missing;
            }

            @Override
            public int docValueCount() {
                return this.count == 0 ? 1 : this.count;
            }

            public String toString() {
                return "anon SortedNumericDoubleValues of [" + super.toString() + "]";
            }
        };
    }

    public static ValuesSource.Bytes replaceMissing(final ValuesSource.Bytes.WithOrdinals valuesSource, final BytesRef missing) {
        return new ValuesSource.Bytes.WithOrdinals(){

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                SortedBinaryDocValues values = valuesSource.bytesValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            @Override
            public SortedSetDocValues ordinalsValues(LeafReaderContext context) throws IOException {
                SortedSetDocValues values = valuesSource.ordinalsValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            @Override
            public SortedSetDocValues globalOrdinalsValues(LeafReaderContext context) throws IOException {
                SortedSetDocValues values = valuesSource.globalOrdinalsValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            @Override
            public LongUnaryOperator globalOrdinalsMapping(LeafReaderContext context) throws IOException {
                return MissingValues.getGlobalMapping(valuesSource.ordinalsValues(context), valuesSource.globalOrdinalsValues(context), valuesSource.globalOrdinalsMapping(context), missing);
            }

            public String toString() {
                return "anon ValuesSource.Bytes.WithOrdinals of [" + super.toString() + "]";
            }
        };
    }

    static SortedSetDocValues replaceMissing(SortedSetDocValues values, BytesRef missing) throws IOException {
        long missingOrd = values.lookupTerm(missing);
        if (missingOrd >= 0L) {
            return MissingValues.replaceMissingOrd(values, missingOrd);
        }
        long insertedOrd = -1L - missingOrd;
        return MissingValues.insertOrd(values, insertedOrd, missing);
    }

    static SortedSetDocValues replaceMissingOrd(final SortedSetDocValues values, final long missingOrd) {
        return new AbstractSortedSetDocValues(){
            private boolean hasOrds;
            private long nextMissingOrd;

            @Override
            public BytesRef lookupOrd(long ord) throws IOException {
                return values.lookupOrd(ord);
            }

            @Override
            public long getValueCount() {
                return values.getValueCount();
            }

            @Override
            public long nextOrd() throws IOException {
                if (this.hasOrds) {
                    return values.nextOrd();
                }
                long ordToReturn = this.nextMissingOrd;
                this.nextMissingOrd = -1L;
                return ordToReturn;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.hasOrds = values.advanceExact(doc);
                this.nextMissingOrd = missingOrd;
                return true;
            }

            public String toString() {
                return "anon AbstractSortedDocValues of [" + super.toString() + "]";
            }
        };
    }

    static SortedSetDocValues insertOrd(final SortedSetDocValues values, final long insertedOrd, final BytesRef missingValue) {
        return new AbstractSortedSetDocValues(){
            private boolean hasOrds;
            private long nextMissingOrd;

            @Override
            public BytesRef lookupOrd(long ord) throws IOException {
                if (ord < insertedOrd) {
                    return values.lookupOrd(ord);
                }
                if (ord > insertedOrd) {
                    return values.lookupOrd(ord - 1L);
                }
                return missingValue;
            }

            @Override
            public long getValueCount() {
                return 1L + values.getValueCount();
            }

            @Override
            public long nextOrd() throws IOException {
                if (this.hasOrds) {
                    long ord = values.nextOrd();
                    if (ord < insertedOrd) {
                        return ord;
                    }
                    return ord + 1L;
                }
                long ordToReturn = this.nextMissingOrd;
                this.nextMissingOrd = -1L;
                return ordToReturn;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.hasOrds = values.advanceExact(doc);
                this.nextMissingOrd = insertedOrd;
                return true;
            }

            public String toString() {
                return "anon AbstractSortedDocValues of [" + super.toString() + "]";
            }
        };
    }

    static LongUnaryOperator getGlobalMapping(SortedSetDocValues values, SortedSetDocValues globalValues, LongUnaryOperator segmentToGlobalOrd, BytesRef missing) throws IOException {
        long missingGlobalOrd = globalValues.lookupTerm(missing);
        long missingSegmentOrd = values.lookupTerm(missing);
        if (missingSegmentOrd >= 0L) {
            return segmentToGlobalOrd;
        }
        if (missingGlobalOrd >= 0L) {
            long insertedSegmentOrd = -1L - missingSegmentOrd;
            long insertedGlobalOrd = missingGlobalOrd;
            return segmentOrd -> {
                if (insertedSegmentOrd == segmentOrd) {
                    return insertedGlobalOrd;
                }
                if (insertedSegmentOrd > segmentOrd) {
                    return segmentToGlobalOrd.applyAsLong(segmentOrd);
                }
                return segmentToGlobalOrd.applyAsLong(segmentOrd - 1L);
            };
        }
        long insertedSegmentOrd = -1L - missingSegmentOrd;
        long insertedGlobalOrd = -1L - missingGlobalOrd;
        return segmentOrd -> {
            if (insertedSegmentOrd == segmentOrd) {
                return insertedGlobalOrd;
            }
            if (insertedSegmentOrd > segmentOrd) {
                return segmentToGlobalOrd.applyAsLong(segmentOrd);
            }
            return 1L + segmentToGlobalOrd.applyAsLong(segmentOrd - 1L);
        };
    }

    public static ValuesSource.GeoPoint replaceMissing(final ValuesSource.GeoPoint valuesSource, final GeoPoint missing) {
        return new ValuesSource.GeoPoint(){

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing(valuesSource.bytesValues(context), new BytesRef(missing.toString()));
            }

            @Override
            public MultiGeoPointValues geoPointValues(LeafReaderContext context) {
                MultiGeoPointValues values = valuesSource.geoPointValues(context);
                return MissingValues.replaceMissing(values, missing);
            }

            public String toString() {
                return "anon ValuesSource.GeoPoint of [" + super.toString() + "]";
            }
        };
    }

    static MultiGeoPointValues replaceMissing(final MultiGeoPointValues values, final GeoPoint missing) {
        return new MultiGeoPointValues(){
            private int count;

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.count = values.advanceExact(doc) ? values.docValueCount() : 0;
                return true;
            }

            @Override
            public int docValueCount() {
                return this.count == 0 ? 1 : this.count;
            }

            @Override
            public GeoPoint nextValue() throws IOException {
                if (this.count > 0) {
                    return values.nextValue();
                }
                return missing;
            }

            public String toString() {
                return "anon MultiGeoPointValues of [" + super.toString() + "]";
            }
        };
    }
}

