/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.FieldSortBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortOrder;

public class BucketSortPipelineAggregator
extends PipelineAggregator {
    private final List<FieldSortBuilder> sorts;
    private final int from;
    private final Integer size;
    private final BucketHelpers.GapPolicy gapPolicy;

    BucketSortPipelineAggregator(String name, List<FieldSortBuilder> sorts, int from, Integer size, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, (String[])sorts.stream().map(FieldSortBuilder::getFieldName).toArray(String[]::new), metadata);
        this.sorts = sorts;
        this.from = from;
        this.size = size;
        this.gapPolicy = gapPolicy;
    }

    public BucketSortPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.sorts = in.readList(FieldSortBuilder::new);
        this.from = in.readVInt();
        this.size = in.readOptionalVInt();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeList(this.sorts);
        out.writeVInt(this.from);
        out.writeOptionalVInt(this.size);
        this.gapPolicy.writeTo(out);
    }

    @Override
    public String getWriteableName() {
        return "bucket_sort";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        int currentSize;
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List<InternalMultiBucketAggregation.InternalBucket> buckets = originalAgg.getBuckets();
        int bucketsCount = buckets.size();
        int n = currentSize = this.size == null ? bucketsCount : this.size;
        if (this.from >= bucketsCount) {
            return originalAgg.create(Collections.emptyList());
        }
        if (this.sorts.size() == 0) {
            return originalAgg.create(new ArrayList<InternalMultiBucketAggregation.InternalBucket>(buckets.subList(this.from, Math.min(this.from + currentSize, bucketsCount))));
        }
        ArrayList<ComparableBucket> ordered = new ArrayList<ComparableBucket>();
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            ComparableBucket comparableBucket = new ComparableBucket(originalAgg, bucket);
            if (comparableBucket.skip()) continue;
            ordered.add(comparableBucket);
        }
        Collections.sort(ordered);
        int limit = Math.min(this.from + currentSize, ordered.size());
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (int i = this.from; i < limit; ++i) {
            newBuckets.add(((ComparableBucket)ordered.get(i)).internalBucket);
        }
        return originalAgg.create(newBuckets);
    }

    private class ComparableBucket
    implements Comparable<ComparableBucket> {
        private final MultiBucketsAggregation parentAgg;
        private final InternalMultiBucketAggregation.InternalBucket internalBucket;
        private final Map<FieldSortBuilder, Comparable<Object>> sortValues;

        private ComparableBucket(MultiBucketsAggregation parentAgg, InternalMultiBucketAggregation.InternalBucket internalBucket) {
            this.parentAgg = parentAgg;
            this.internalBucket = internalBucket;
            this.sortValues = this.resolveAndCacheSortValues();
        }

        private Map<FieldSortBuilder, Comparable<Object>> resolveAndCacheSortValues() {
            HashMap<FieldSortBuilder, Comparable<Object>> resolved = new HashMap<FieldSortBuilder, Comparable<Object>>();
            for (FieldSortBuilder sort : BucketSortPipelineAggregator.this.sorts) {
                String sortField = sort.getFieldName();
                if ("_key".equals(sortField)) {
                    resolved.put(sort, (Comparable)this.internalBucket.getKey());
                    continue;
                }
                Double bucketValue = BucketHelpers.resolveBucketValue(this.parentAgg, this.internalBucket, sortField, BucketSortPipelineAggregator.this.gapPolicy);
                if (BucketHelpers.GapPolicy.SKIP == BucketSortPipelineAggregator.this.gapPolicy && Double.isNaN(bucketValue)) continue;
                resolved.put(sort, bucketValue);
            }
            return resolved;
        }

        private boolean skip() {
            return this.sortValues.isEmpty();
        }

        @Override
        public int compareTo(ComparableBucket that) {
            int compareResult = 0;
            for (FieldSortBuilder sort : BucketSortPipelineAggregator.this.sorts) {
                Comparable<Object> thisValue = this.sortValues.get(sort);
                Comparable<Object> thatValue = that.sortValues.get(sort);
                if (thisValue == null && thatValue == null) continue;
                if (thisValue == null) {
                    return 1;
                }
                if (thatValue == null) {
                    return -1;
                }
                compareResult = sort.order() == SortOrder.DESC ? -thisValue.compareTo(thatValue) : thisValue.compareTo(thatValue);
                if (compareResult == 0) continue;
                break;
            }
            return compareResult;
        }
    }
}

